package ohd.hseb.hefs.mefp.sources.historical;

import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.pe.model.AlgorithmModelParameters;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;

/**
 * Special version required for climatology; see constructor comment below.
 * 
 * @author hankherr
 */
public class HistoricalSourceModelParameters extends MEFPSourceModelParameters
{
    /**
     * Calls {@link #removeDistributionOfFcsts()} to ensure that the distribution of forecasts is not included in XML
     * and cannot be used!
     * 
     * @param identifier
     * @param source
     * @param algorithmParameters
     */
    public HistoricalSourceModelParameters(final LocationAndDataTypeIdentifier identifier,
                                           final HistoricalForecastSource source,
                                           final AlgorithmModelParameters algorithmParameters)
    {
        super(identifier, source, algorithmParameters, true);

        super.removeDistributionOfFcsts();
    }
}
