package ohd.hseb.hefs.mefp.sources.plugin;

import ohd.hseb.hefs.utils.xml.XMLReaderAdapter;
import ohd.hseb.hefs.utils.xml.XMLWriterAdapter;
import ohd.hseb.hefs.utils.xml.vars.XMLString;

/**
 * Abstract implementation of {@link ReforecastPreparationStepInstructions}. Provides {@link #_stepId} and
 * {@link #_stepDescription} variables along with
 * {@link #addReforecastPreparationStepInstructionsAttributes(XMLReaderAdapter)} and
 * {@link #addReforecastPreparationStepInstructionsAttributes(XMLWriterAdapter)} to be used to add appropriate
 * attributes for those two variables. Instructions must always include a step id and step description.
 * 
 * @author hankherr
 */
public abstract class AbstractReforecastPreparationStepInstructions implements ReforecastPreparationStepInstructions
{

    protected XMLString _stepId = new XMLString("stepId");
    protected XMLString _stepDescription = new XMLString("stepDescription");

    /**
     * @param var {@link XMLWriterAdapter} to which to add the two required attributes.
     */
    protected void addReforecastPreparationStepInstructionsAttributes(final XMLWriterAdapter var)
    {
        var.addAttribute(_stepId, true);
        var.addAttribute(_stepDescription, true);
    }

    /**
     * @param var {@link XMLReaderAdapter} to which to add the two required attributes.
     */
    protected void addReforecastPreparationStepInstructionsAttributes(final XMLReaderAdapter var)
    {
        var.addAttribute(_stepId, true);
        var.addAttribute(_stepDescription, true);
    }

    public void setStepId(final String id)
    {
        _stepId.set(id);
    }

    public void setStepDescription(final String desc)
    {
        _stepDescription.set(desc);
    }

    /**
     * To be called by subclass clone methods.
     * 
     * @param base
     */
    protected void copyFrom(final AbstractReforecastPreparationStepInstructions base)
    {
        _stepId = (XMLString)base._stepId.clone();
        _stepDescription = (XMLString)base._stepDescription.clone();
    }

    @Override
    public String getStepId()
    {
        return _stepId.get();
    }

    @Override
    public String getStepDescription()
    {
        return _stepDescription.get();
    }

    /**
     * All subclass should call this equals method.
     */
    @Override
    public boolean equals(final Object obj)
    {
        final AbstractReforecastPreparationStepInstructions other = (AbstractReforecastPreparationStepInstructions)obj;
        return ((_stepId.equals(other._stepId)) && (_stepDescription.equals(other._stepDescription)));
    }

    /**
     * All subclasses must override this clone method.
     */
    @Override
    public abstract AbstractReforecastPreparationStepInstructions clone();
}
