package ohd.hseb.hefs.mefp.sources.plugin;

import java.util.Collection;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.charter.ChartEngine;
import ohd.hseb.charter.datasource.DefaultXYChartDataSource;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.pe.tools.DiagnosticChartBuilder;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.TimeSeriesChartDiagnosticPanel;
import ohd.hseb.hefs.utils.gui.help.HelpFile;

/**
 * The diagnostic panel to use for for plug-in reforecasts.
 * 
 * @author hank.herr
 */
@HelpFile("PDFHELP:helpManual.pdf#GEFSDiagnosticsPanelRef")
public class PluginDiagnosticPanel extends TimeSeriesChartDiagnosticPanel
{
    private static final long serialVersionUID = 1L;

    private DiagnosticChartBuilder _chartBuilder;

    @SuppressWarnings("unchecked")
    public PluginDiagnosticPanel(final MEFPForecastSource source,
                                 final LocationAndDataTypeIdentifier identifier,
                                 final Collection<TimeSeriesArray> timeSeries)
    {
        super(identifier, timeSeries);
        setDateListDateFormat("CCYY-MM-DD hh'h'");
        try
        {
            String paramFile;
            if(getIdentifier().isPrecipitationDataType())
            {
                paramFile = "mefppe/diagnostics/pluginPrecipitationDisplayDiagnostics.xml";
            }
            else if(getIdentifier().isTemperatureDataType())
            {
                paramFile = "mefppe/diagnostics/pluginTemperatureDisplayDiagnostics.xml";
            }
            else
            {
                throw new Exception("Unknown parameter type.");
            }
            _chartBuilder = new DiagnosticChartBuilder(getIdentifier(), paramFile, source.getSourceId(), getAllSeries());
        }
        catch(final Exception e)
        {
            error(e);
        }

        updateChart();
    }

    @Override
    protected boolean hasYearSpinner()
    {
        return true;
    }

    @Override
    protected boolean hasForecastList()
    {
        return true;
    }

    @Override
    protected ChartEngine buildChart() throws Exception
    {
        _chartBuilder.setYear(getSelectedYear());
        _chartBuilder.setEmphasizedDates(getSelectedDates());
        if(!_chartBuilder.getParameters()
                         .getTemplateParameters()
                         .getChartDrawingParameters()
                         .getPlotTitle()
                         .getText()
                         .endsWith("6h Precipitation Amounts for 60 days"))
        {
            _chartBuilder.getParameters()
                         .getTemplateParameters()
                         .getChartDrawingParameters()
                         .getPlotTitle()
                         .setText(_chartBuilder.getParameters()
                                               .getTemplateParameters()
                                               .getChartDrawingParameters()
                                               .getPlotTitle()
                                               .getText()
                             + "\n6h Precipitation Amounts for 60 days");
        }

        final ChartEngine engine = _chartBuilder.buildChartEngine();

        //Setup the source names
        ((DefaultXYChartDataSource)engine.getDataSources().get(0)).setSourceNameInTable("Emphasized Ensemble Mean");
        ((DefaultXYChartDataSource)engine.getDataSources().get(1)).setSourceNameInTable("Emphasized Members");
        ((DefaultXYChartDataSource)engine.getDataSources().get(2)).setSourceNameInTable("Historical Observed");
        ((DefaultXYChartDataSource)engine.getDataSources().get(3)).setSourceNameInTable("Reforecasts");

        return engine;
    }
}
