package ohd.hseb.hefs.mefp.sources.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import nl.wldelft.util.timeseries.TimeSeriesArray;
import ohd.hseb.hefs.mefp.models.precipitation.PrecipitationParameterEstimationModel;
import ohd.hseb.hefs.mefp.models.temperature.TemperatureParameterEstimationModel;
import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.GriddedPEStepOptionsPanel;
import ohd.hseb.hefs.pe.core.ParameterEstimatorDiagnosticPanel;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.help.HelpFile;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * A {@link GriddedPEStepOptionsPanel} to use with all plug-ins.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
@HelpFile("PDFHELP:helpManual.pdf#GEFSSubpanelRef")
public class PluginPEStepOptionsPanel extends GriddedPEStepOptionsPanel
{
    private static final Logger LOG = LogManager.getLogger(PluginPEStepOptionsPanel.class);

    public PluginPEStepOptionsPanel(final MEFPParameterEstimatorRunInfo runInfo,
                                    final PluginPEStepProcessor stepProcessor)
    {
        super(runInfo, stepProcessor);
    }

    @Override
    protected ParameterEstimatorDiagnosticPanel instantiateDiagnosticPanel(final LocationAndDataTypeIdentifier identifier,
                                                                           final Collection<TimeSeriesArray> tsc)
    {
        return new PluginDiagnosticPanel(this.getSource(), identifier, tsc);
    }

    @Override
    protected String getSourceTimeSeriesShortName()
    {
        return this.getSource().getSourceId();
    }

    @Override
    public PluginDataHandler getHandler()
    {
        return (PluginDataHandler)super.getHandler();
    }

    @Override
    protected Collection<TimeSeriesArray> loadDiagnosticTimeSeries(final List<LocationAndDataTypeIdentifier> identifiers) throws Exception
    {
        final Collection<TimeSeriesArray> tsc = new ArrayList<TimeSeriesArray>();
        getHandler().loadPreparedTimeSeries(identifiers);
        tsc.addAll(getHandler().getAllLoadedForecastTimeSeriesForDiagnostics());

        //Observed TS -- Copied from the super class version!
        for(final LocationAndDataTypeIdentifier identifier: identifiers)
        {
            try
            {
                if(identifier.isPrecipitationDataType())
                {
                    tsc.add(PrecipitationParameterEstimationModel.retrieveHistoricalData((MEFPParameterEstimatorRunInfo)getRunInfo(),
                                                                                         identifier));
                }
                else if(identifier.isTemperatureDataType())
                {
                    tsc.addAll(TemperatureParameterEstimationModel.retrieveHistoricalData((MEFPParameterEstimatorRunInfo)getRunInfo(),
                                                                                          identifier));
                }
                else
                {
                    throw new IllegalArgumentException("Identifier " + identifier.buildStringToDisplayInTree()
                        + " is neither precip nor temp.  How did that happen?");
                }
            }
            catch(final Exception e)
            {
                LOG.warn("Unable to load observed data for display in diagnostic plot: " + e.getMessage());
                LOG.warn("Be sure that the processed historical data file has been generated.");
            }
        }

        return tsc;
    }

}
