package ohd.hseb.hefs.mefp.sources.plugin;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.sources.GriddedPEStepProcessor;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceDataHandler;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.StepUnit;

/**
 * The {@link ParameterEstimatorStepProcessor} used for all MEFPPE {@link PluginForecastSource} instances. This step
 * does NOT include an ebabled run button! Rather, the run button will be disabled and have a tool tip explaining that
 * the setup panel should be used to prepare reforecasts.
 * 
 * @author hankherr
 */
public class PluginPEStepProcessor extends GriddedPEStepProcessor
{

    public PluginPEStepProcessor(final MEFPParameterEstimatorRunInfo runInfo, final String sourceId)
    {
        super(runInfo, (MEFPForecastSource)runInfo.getForecastSource(sourceId));
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return new PluginPEStepOptionsPanel(getRunInfo(), this);
    }

    @Override
    protected MEFPSourceDataHandler instantiateSFTPHandler() throws Exception
    {
        return null; //There is no step to perform, so no SFTP handler is needed.
    }

    @Override
    public void performStep(final StepUnit unit) throws Exception
    {
        throw new Exception("Gridded plugins have no associated step to perform.  Rather, the Setup Panel is used to acquire the reforecast data for these steps.");
    }

    /**
     * The run-button will be disabled and this will specify its tool tip.
     */
    @Override
    public String getToolTipTextDescribingStep()
    {
        return "To prepare reforecasts for the source " + getSource().getSourceId()
            + ", go to the Setup Panel and select the appropriate tab.";
    }

    @Override
    public String getShortNameForIdentifierTableColumn()
    {
        return getSource().getSourceId();
    }

    @Override
    public String getToolTipTextForIdentifierTableColumnHeader()
    {
        return "<html>Displays if the files specifying " + getSource().getSourceId()
            + " reforecasts for a location and " + "data type were found under<br>"
            + getHandler().getPreparedDataFilesDirectory() + ".</html>";
    }

    @Override
    public String getTabNameForStep()
    {
        return getSource().getSourceId();
    }

    /**
     * The run-button will be disabled.
     */
    @Override
    public String getStepNameForRunButton()
    {
        return null; //Disable run button!
    }

    @Override
    public String getPerformStepPrefix()
    {
        return null; //No step to perform
    }
}
