package ohd.hseb.hefs.mefp.sources.plugin;

import javax.swing.JTextArea;

import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLWritable;

/**
 * Instructions interface specifying a step to perform within the {@link ReforecastPreparationSteps}.
 * 
 * @author hankherr
 */
public interface ReforecastPreparationStepInstructions extends XMLReadable, XMLWritable, Cloneable
{

    /**
     * @return An identifier to be associated with the step if it needs to be referred to elsewhere.
     */
    public String getStepId();

    /**
     * @return A description to be displayed in the GUI somewhere.
     */
    public String getStepDescription();

    /**
     * Will override the clone method in {@link Object} for all implementing subclasses.
     */
    public ReforecastPreparationStepInstructions clone();

    /**
     * @return The XML element name associated with the implementing class.
     */
    public String getXMLTagName();

    /**
     * @return A step processor ready to process the step described in this set of instructions.
     */
    public ReforecastPreparationStepProcessor createProcessor(PluginForecastSource source);

    /**
     * @return A {@link String} to be displayed within a {@link JTextArea} in the panel displayed within the interface.
     *         It should summarize the contents of the instructions and use new-lines as needed (html-br tags should not
     *         be used).
     */
    public String getInstructionSummaryForInterface();

}
