package ohd.hseb.hefs.mefp.sources.plugin.steps;

import java.io.File;

import ohd.hseb.hefs.utils.notify.Notice;

/**
 * Notice fired by {@link SFTPProcessor} indicating a file has been placed in the final directory for processing via
 * CHPS workflow.
 * 
 * @author Hank.Herr
 */
public class SFTPFilePutInPlaceNotice extends Notice
{
    /**
     * The {@link File} on the server that was acquired and put in the target directory, probably for import.
     */
    private final File _serverFile;

    /**
     * If true, then this is the last file to process.
     */
    private final boolean _lastFile;

    public SFTPFilePutInPlaceNotice(final Object source, final File serverFile, final boolean lastFile)
    {
        super(source);
        _serverFile = serverFile;
        _lastFile = lastFile;
    }

    public File getServerFile()
    {
        return _serverFile;
    }

    public boolean getLastFile()
    {
        return _lastFile;
    }

    public static interface Subscriber
    {
        public void reactToSFTPFilePutInPlace(SFTPFilePutInPlaceNotice evt);
    }
}
