package ohd.hseb.hefs.mefp.sources.plugin.steps;

import java.util.ArrayList;
import java.util.List;

import ohd.hseb.hefs.mefp.sources.plugin.PluginForecastSource;
import ohd.hseb.hefs.mefp.sources.plugin.ReforecastPreparationStepProcessor;
import ohd.hseb.hefs.utils.jobs.JobMessenger;
import ohd.hseb.hefs.utils.jobs.JobMonitorAttr;
import ohd.hseb.util.CommandAdapter;
import ohd.hseb.util.misc.HString;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

/**
 * Makes the system call dictated by the {@link SystemCallInstructions} and waits for it to finish. It makes use of
 * {@link CommandAdapter}.
 * 
 * @author hankherr
 */
public class SystemCallProcessor extends ReforecastPreparationStepProcessor
{
    private static final Logger LOG = LogManager.getLogger(SystemCallProcessor.class);

    public SystemCallProcessor(final PluginForecastSource source, final SystemCallInstructions instructions)
    {
        super(source, instructions, LOG);
    }

    @Override
    public SystemCallInstructions getInstructions()
    {
        return (SystemCallInstructions)super.getInstructions();
    }

    @Override
    public boolean isStepComplete()
    {
        return false; //Never complete.
    }

    @Override
    public boolean canStepBePerformed()
    {
        return true; //Can always be run, since we can't know what it does.
    }

    @Override
    public void clearProgress()
    {
        //Does nothing... no progress recorded.
    }

    @Override
    public JobMonitorAttr determineJobStatus(final boolean fullDetermination)
    {
        final JobMonitorAttr attr = new JobMonitorAttr();
        attr.setIndeterminate(false);
        attr.setMaximum(1);
        attr.setMinimum(0);
        attr.setProgress(0);
        attr.setNote("Command ready to be executed.");
        return attr;
    }

    @Override
    public void process() throws Exception
    {
        JobMessenger.setIndeterminate(true);

        final List<String> args = new ArrayList<String>();
        args.add(getInstructions().getSystemCommand());
        args.addAll(getInstructions().getArguments());

        JobMessenger.updateNote("Executing command: " + HString.buildStringFromList(args, " "));

        final CommandAdapter adapter = new CommandAdapter();
        adapter.invoke(args.toArray(new String[1]), true, false);

        JobMessenger.updateNote("Done executing command.");
    }

}
