package ohd.hseb.hefs.mefp.sources.plugin.steps;

import ohd.hseb.hefs.utils.xml.CompositeXMLReader;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.vars.XMLInteger;
import ohd.hseb.hefs.utils.xml.vars.XMLString;

/**
 * Instructions to use for {@link WorkflowProcessor}, includes maximum allowable wait times for waiting to execute
 * (i.e., waiting for the {@link SFTPProcessor} to put a file in place) and waiting for a execute to be complete.
 * Additionally, the CHPS workflow id must be specified.
 * 
 * @author hankherr
 */
public class WorkflowInstructions implements XMLReadable, XMLWritable, Cloneable
{

    private final XMLInteger _maxWaitToExecute = new XMLInteger("maxWaitToExecute", 30000, 0, null); //Defaults to 30 seconds.
    private final XMLInteger _maxWaitForExecutionToComplete = new XMLInteger("maxWaitForExecutionToComplete",
                                                                             30000,
                                                                             0,
                                                                             null); //Defaults to 30 seconds.

    private final XMLString _workflowID = new XMLString("workflowID");

    public WorkflowInstructions()
    {
        _workflowID.setRequired(true);
    }

    public String getWorkflowID()
    {
        return _workflowID.get();
    }

    public void setWorkflowID(final String id)
    {
        _workflowID.set(id);
    }

    public int getMaxWaitToExecute()
    {
        return _maxWaitToExecute.get();
    }

    public void setMaxWaitToExecute(final int millis)
    {
        _maxWaitToExecute.set(millis);
    }

    public int getMaxWaitForExecutionToComplete()
    {
        return _maxWaitForExecutionToComplete.get();
    }

    public void setMaxWaitForExecutionToComplete(final int millis)
    {
        _maxWaitForExecutionToComplete.set(millis);
    }

    public String getXMLTagName()
    {
        return "workflowInstructions";
    }

    @Override
    public XMLWriter getWriter()
    {
        final CompositeXMLWriter writer = new CompositeXMLWriter(getXMLTagName(), _workflowID);
        writer.addAttribute(_maxWaitToExecute, false);
        writer.addAttribute(_maxWaitForExecutionToComplete, false);
        return writer;
    }

    @Override
    public XMLReader getReader()
    {
        final CompositeXMLReader reader = new CompositeXMLReader(getXMLTagName(), _workflowID);
        reader.addAttribute(_maxWaitToExecute, false);
        reader.addAttribute(_maxWaitForExecutionToComplete, false);
        return reader;
    }

    @Override
    public boolean equals(final Object obj)
    {
        final WorkflowInstructions other = (WorkflowInstructions)obj;
        return (_workflowID.equals(other._workflowID))
            && (_maxWaitToExecute.equals(other._maxWaitToExecute) && (_maxWaitForExecutionToComplete.equals(other._maxWaitForExecutionToComplete)));
    }

    @Override
    public WorkflowInstructions clone()
    {
        final WorkflowInstructions cloned = new WorkflowInstructions();
        cloned._workflowID.set(_workflowID.get());
        cloned._maxWaitToExecute.set(_maxWaitToExecute.get());
        cloned._maxWaitForExecutionToComplete.set(_maxWaitForExecutionToComplete.get());
        return cloned;
    }

}
