package ohd.hseb.hefs.mefp.sources.rfcfcst;

import ohd.hseb.hefs.utils.Duration;
import ohd.hseb.hefs.utils.tools.ParameterId;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.google.common.base.Strings;

/**
 * Code used by both PedtsepCode and VfyPairPedtsepCode. It does not include the ts.
 * 
 * @author alexander.garbarino
 */
abstract class PedtsepCodeBase implements XMLWriter
{
    private final String _pe;
    private final String _d;
    private final String _e;
    private final String _p;

    protected PedtsepCodeBase(final String pe, final String d, final String e, final String p)
    {
        _pe = pe;
        _d = d;
        _e = e;
        _p = p;
    }

    protected static String processPE(String pe)
    {
        pe = Strings.emptyToNull(pe);
        if(pe != null && pe.length() != 2)
        {
            throw new IllegalArgumentException("PE code must be of length 2.");
        }
        if("__".equals(pe))
        {
            return null;
        }
        return pe;
    }

    protected static String processD(String d)
    {
        d = Strings.emptyToNull(d);
        if(d != null && d.length() != 1)
        {
            throw new IllegalArgumentException("D code must be of length 1.");
        }
        if(d != null)
        {
            Pedtsep.D.valueOf(d);
        }
        if("_".equals(d))
        {
            return null;
        }
        return d;
    }

    protected static String processTS(String ts)
    {
        ts = Strings.emptyToNull(ts);
        if(ts != null && ts.length() != 2)
        {
            throw new IllegalArgumentException("TS code must be of length 2.");
        }
        if("__".equals(ts))
        {
            return null;
        }
        return ts;
    }

    protected static String processE(String e)
    {
        e = Strings.emptyToNull(e);
        if(e != null && e.length() != 1)
        {
            throw new IllegalArgumentException("E code must be of length 1.");
        }
        if("_".equals(e))
        {
            return null;
        }
        return e;
    }

    protected static String processP(String p)
    {
        p = Strings.emptyToNull(p);
        if(p != null && p.length() != 1)
        {
            throw new IllegalArgumentException("P code must be of length 1.");
        }
        if("_".equals(p))
        {
            return null;
        }
        return p;
    }

    public String getPE()
    {
        return _pe;
    }

    public String getD()
    {
        return _d;
    }

    public String getE()
    {
        return _e;
    }

    public String getP()
    {
        return _p;
    }

    public ParameterId.Type getType()
    {
        try
        {
            return Pedtsep.PE.valueOf(_pe).getType();
        }
        catch(final Exception e)
        {
            return null;
        }
    }

    public ParameterId.Extremum getExtremum()
    {
        try
        {
            return Pedtsep.E.valueOf(_e).getExetremum();
        }
        catch(final Exception e)
        {
            return null;
        }
    }

    public Duration getDuration()
    {
        try
        {
            return Pedtsep.D.valueOf(_d).getDuration();
        }
        catch(final Exception e)
        {
            return null;
        }
    }

    /**
     * Retrieves the duration ('d') as an integer.
     * 
     * @return
     */
    public int getDurationInHours()
    {
        try
        {
            return (int)Pedtsep.D.valueOf(_d).getHours();
        }
        catch(final Exception e)
        {
            return -1;
        }
    }

    /**
     * @return the duration in milliseconds
     */
    public long getDurationInMillis()
    {
        try
        {
            return Pedtsep.D.valueOf(_d).getMillis();
        }
        catch(final Exception e)
        {
            return -1;
        }
    }

    @Override
    public boolean equals(final Object other)
    {
        if(this.getClass() != other.getClass())
        {
            return false;
        }
        return toString().equals(other.toString());
    }

    @Override
    public int hashCode()
    {
        return toString().hashCode();
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        return XMLTools.createTextNodeElement(request, getXMLTagName(), toString());
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
