package ohd.hseb.hefs.mefp.sources.rfcfcst;

import java.text.ParseException;

import javax.swing.text.DefaultFormatter;

@SuppressWarnings("serial")
public class PedtsepFormatter extends DefaultFormatter
{
    public PedtsepFormatter()
    {
        setAllowsInvalid(true);
        setCommitsOnValidEdit(true);
        setOverwriteMode(false);
        setValueClass(PedtsepCode.class);
    }

    @Override
    public PedtsepCode stringToValue(String string) throws ParseException
    {
        try
        {
            return PedtsepCode.make(string);
        }
        catch(IllegalArgumentException e)
        {
            throw new ParseException("Invalid Pedtsep Code: " + string, 0);
        }
    }
}
