package ohd.hseb.hefs.mefp.sources.rfcfcst;

import java.io.File;

import ohd.hseb.hefs.mefp.models.parameters.MEFPSourceModelParameters;
import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.pe.estimation.GenericMEFPSourceControlOptions;
import ohd.hseb.hefs.mefp.pe.estimation.MEFPPrecipitationSourceControlOptions;
import ohd.hseb.hefs.mefp.sources.AbstractMEFPForecastSource;
import ohd.hseb.hefs.mefp.sources.MEFPSourceControlOptions;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.model.AlgorithmModelParameters;
import ohd.hseb.hefs.pe.sources.SourceDataHandler;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.notify.NoticePoster;
import ohd.hseb.hefs.utils.tools.ParameterId;

public class RFCForecastSource extends AbstractMEFPForecastSource
{
    /**
     * This ===MUST=== match the portion of the source name before 'ForecastSource', so that it matches the default
     * return of {@link #getSourceId()}.
     */
    public final static String SOURCE_ID = "RFC";

    @Override
    public String getName()
    {
        return "RFC QPF/QTF Forecasts";
    }

    @Override
    public MEFPSourceModelParameters getSourceModelParameters(final LocationAndDataTypeIdentifier identifier,
                                                              final AlgorithmModelParameters algorithmParameters)
    {
        final MEFPSourceModelParameters parameters = new MEFPSourceModelParameters(identifier,
                                                                                   this,
                                                                                   algorithmParameters,
                                                                                   false);
        return parameters;
    }

    @Override
    public RFCForecastDataHandler getSourceDataHandler()
    {
        return (RFCForecastDataHandler)super.getSourceDataHandler();
    }

    @Override
    protected void setSourceDataHandler(final SourceDataHandler handler)
    {
        if(!(handler instanceof RFCForecastDataHandler))
        {
            throw new IllegalArgumentException("The SourceDataHandler is not a RFCDataHandler.");
        }
        super.setSourceDataHandler(handler);
    }

    @Override
    public MEFPSourceControlOptions createControlOptions(final ParameterId.Type type)
    {
        switch(type)
        {
            case TEMPERATURE:
                return new GenericMEFPSourceControlOptions("rfcTemperatureControlOptions", this);
            case PRECIPITATION:
                return new MEFPPrecipitationSourceControlOptions("rfcPrecipitationControlOptions", this);
            default:
                throw new IllegalArgumentException(String.format("%s not supported.", type));
        }
    }

    @Override
    public void initializeSourceDataHandler(final File baseDirectory, final NoticePoster poster) throws Exception
    {
        this.setSourceDataHandler(new RFCForecastDataHandler(baseDirectory));
    }

    @Override
    public ParameterEstimatorStepProcessor getSourceStepProcessor(final ParameterEstimatorRunInfo runInfo)
    {
        return new RFCForecastPEStepProcessor((MEFPParameterEstimatorRunInfo)runInfo);
    }

}
