package ohd.hseb.hefs.mefp.sources.rfcfcst;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JOptionPane;
import javax.swing.JTable;

import ohd.hseb.hefs.mefp.pe.core.MEFPParameterEstimatorRunInfo;
import ohd.hseb.hefs.mefp.tools.MEFPSubEditor;
import ohd.hseb.hefs.pe.core.ParameterEstimatorTableModel;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.TableTools;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.notify.ObjectModifiedNotice;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class RFCPedtsepSubEditor extends MEFPSubEditor
{
    private final PedtsepTableModel _model;
    private final JTable _table;

    private final LocationAndDataTypeIdentifier _identifier;
    private final int _codeIndex;

    public RFCPedtsepSubEditor(MEFPParameterEstimatorRunInfo runInfo,
                               LocationAndDataTypeIdentifier identifier,
                               int codeIndex)
    {
        super(runInfo);

        _model = new PedtsepTableModel(getRunInfo());
        _table = new GenericTable(_model);

        _identifier = identifier;
        _codeIndex = codeIndex;

        initializeDisplay();
    }

    public void cancelEditing()
    {
        if(_table.isEditing())
        {
            _table.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    protected void initializeDisplay()
    {
        setPreferredSize(new Dimension(200, 70));
        setMinimumSize(getPreferredSize());

        _table.getTableHeader().setReorderingAllowed(false);
        _table.setRowSelectionAllowed(false);

        this.setLayout(new BorderLayout());
        this.add(TableTools.wrapInPanel(_table, "Edit Forecast PEDTSEP Code"), BorderLayout.CENTER);
        this.setVisible(false);
    }

    private PedtsepCode getInfoCode()
    {
        return getRunInfo().getRfcDataOptions().getSourceCode(_identifier, _codeIndex).asForecast();
    }

    private void setInfoCode(PedtsepCode code)
    {
        getRunInfo().getRfcDataOptions().setSourceCode(_identifier, _codeIndex, code);
    }

    private class PedtsepTableModel extends ParameterEstimatorTableModel implements ObjectModifiedNotice.Subscriber
    {
        private final boolean[] _editable = {true, false, true, true, false};

        private PedtsepTableModel(MEFPParameterEstimatorRunInfo runInfo)
        {
            super(runInfo);
        }

        @Override
        @Subscribe
        public void reactToObjectModified(ObjectModifiedNotice notice)
        {
            if(RFCDataOptions.class.isInstance(notice.getTarget()))
            {
                fireTableDataChanged();
            }
        }

        @Override
        public int getColumnCount()
        {
            return 5;
        }

        @Override
        public int getRowCount()
        {
            return 1;
        }

        @Override
        public Class<?> getColumnClass(int col)
        {
            return String.class;
        }

        @Override
        public String getColumnName(int col)
        {
            if(col == 0)
            {
                return "PE";
            }
            else if(col == 1)
            {
                return "D";
            }
            else if(col == 2)
            {
                return "TS";
            }
            else if(col == 3)
            {
                return "E";
            }
            else if(col == 4)
            {
                return "P";
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col)
        {
            if(col == 0)
            {
                return Strings.nullToEmpty(getInfoCode().getPE());
            }
            else if(col == 1)
            {
                return Strings.nullToEmpty(getInfoCode().getD());
            }
            else if(col == 2)
            {
                return Strings.nullToEmpty(getInfoCode().getTS());
            }
            else if(col == 3)
            {
                return Strings.nullToEmpty(getInfoCode().getE());
            }
            else if(col == 4)
            {
                return Strings.nullToEmpty(getInfoCode().getP());
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col)
        {
            if(!(value instanceof String) && value != null)
            {
                return;
            }
            String val = (String)value;

            //If a type source has been entered, it must be a forecast type source.
            if(col == 2)
            {
                if(getInfoCode().withTS(val).isObserved())
                {
                    JOptionPane.showMessageDialog(SwingTools.getGlobalDialogParent(_table),
                                                  "Type source specified, '" + val
                                                      + "', is for observed data.\nA forecast type source is required.",
                                                  "Bad Type Source",
                                                  JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }

            try
            {
                switch(col)
                {
                    case 0:
                        setInfoCode(getInfoCode().withPE(val));
                        break;
                    case 1:
                        setInfoCode(getInfoCode().withD(val));
                        break;
                    case 2:
                        setInfoCode(getInfoCode().withTS(val));
                        break;
                    case 3:
                        setInfoCode(getInfoCode().withE(val));
                        break;
                    case 4:
                        setInfoCode(getInfoCode().withP(val));
                        break;
                }
                fireTableDataChanged();
            }
            catch(IllegalArgumentException e)
            {
            }
        }

        @Override
        public boolean isCellEditable(int row, int col)
        {
            return _editable[col];
        }

        @Override
        public String getColumnHeaderToolTip(int modelColIndex)
        {
            if(modelColIndex == 0)
            {
                return "Physical Element";
            }
            else if(modelColIndex == 1)
            {
                return "Duration";
            }
            else if(modelColIndex == 2)
            {
                return "Forecast Type Source";
            }
            else if(modelColIndex == 3)
            {
                return "Extremum";
            }
            else if(modelColIndex == 4)
            {
                return "Probability";
            }
            return null;
        }

        @Override
        public String getCellToolTip(int rowIndex, int visibleColIndex)
        {
            return getColumnHeaderToolTip(visibleColIndex);
        }
    }

}
