package ohd.hseb.hefs.mefp.sources.rfcfcst;

import javax.swing.Icon;

import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.tools.IconTools;

import com.google.common.collect.Lists;

public enum RFCStatus implements StatusIndicator
{
    READY(true, "checkMark", "All data has been retrieved according to specification."), //
    NO_OBS(null, "yellowExclamation", "<html>No observed RFC data has been provided for this source.<br>"
        + "Historical (usually datacard) data will be used for observations.</html>"), //
    IMPORTED(true, "blueCheckMark", "Data has been imported directly by user."), //
    NEEDS_UPDATE(null, "yellowExclamation",
    "The retrieval specifications have changed since this data was last retrieved."), //
    MISSING(false, "redX", "1 or more of the data files are missing.");

    private final Boolean _boolean;
    private final Icon _icon;
    private final String _description;

    private RFCStatus(final Boolean b, final String iconName, final String description)
    {
        _boolean = b;
        _icon = IconTools.getHSEBIcon(iconName);
        _description = description;
    }

    @Override
    public boolean isReady()
    {
        return Lists.newArrayList(READY, IMPORTED).contains(this);
    }

    @Override
    public boolean exists()
    {
        return !this.equals(MISSING);
    }

    @Override
    public boolean canBePrepared()
    {
        return true;
    }

    @Override
    public Icon getIcon()
    {
        return _icon;
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public Boolean toBoolean()
    {
        return _boolean;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return true;
    }

}
