package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import ohd.hseb.hefs.utils.notify.ObjectModifiedNotice;

import com.google.common.eventbus.Subscribe;

public class ConnectionTestedNotice extends ObjectModifiedNotice<DatabaseConnectionSpecification>
{
    private final boolean _canConnect;

    public ConnectionTestedNotice(Object source, DatabaseConnectionSpecification target, boolean canConnect)
    {
        super(source, target);
        _canConnect = canConnect;
    }

    public boolean canConnect()
    {
        return _canConnect;
    }

    public static interface Subscriber
    {
        @Subscribe
        void reactToConnectionTested(ConnectionTestedNotice evt);
    }
}
