package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import java.sql.Connection;
import java.sql.SQLException;


/**
 * Representation of an adb database. 
 * @author alexander.garbarino
 */
public class Database
{
    private final DatabaseConnectionSpecification _specification;
    private Connection _connection;
    
    public Database(String host, String port, String database, String user)
    {
        _specification = new DatabaseConnectionSpecification(host, port, database, user);
    }
    
    public Database(DatabaseConnectionSpecification specification)
    {
        _specification = specification;
    }

    /**
     * Connects with the string supplied at construction.
     * @throws SQLException if we could not connect
     * @throws RuntimeException if we are already connected
     */
    public void connect() throws SQLException, RuntimeException
    {
        if(_connection != null)
        {
            throw new RuntimeException("Already connected.");
        }
        
        _connection = _specification.create();
    }

    /**
     * Disconnects.
     * @throws SQLException if there is an underlying error
     * @throws RuntimeException if the connection is already closed
     */
    public void disconnect() throws SQLException, RuntimeException
    {
        try
        {
            _connection.close();
            _connection = null;
        }
        catch(NullPointerException e)
        {
            throw new RuntimeException("No connection to close.", e);
        }
    }
    
    public Connection getConnection()
    {
        return _connection;
    }
    
    /**
     * Returns the active connection, connecting if needed.
     * @return the active connection
     * @throws SQLException if there is an error connecting
     */
    public Connection ensureConnection() throws SQLException
    {
        if(_connection == null)
        {
            connect();
        }
        return _connection;
    }
}
