package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import ohd.hseb.hefs.utils.xml.Properties;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderAdapter;
import ohd.hseb.hefs.utils.xml.XMLReaderException;

import org.xml.sax.Attributes;

import com.google.common.base.Supplier;

public class DatabaseConnectionSpecificationReader extends XMLReaderAdapter implements
Supplier<DatabaseConnectionSpecification>
{
    private DatabaseConnectionSpecification _connection;
    private Properties _properties;

    public DatabaseConnectionSpecificationReader()
    {
        this(new DatabaseConnectionSpecification());
    }

    public DatabaseConnectionSpecificationReader(DatabaseConnectionSpecification connection)
    {
        super(DatabaseConnectionSpecification.XML_TAG);
        _connection = connection;
    }

    @Override
    public DatabaseConnectionSpecification get()
    {
        return _connection;
    }

    @Override
    public void setValueOfElement(String elementName, String value) throws XMLReaderException
    {
        if(DatabaseConnectionSpecification.HOST_TAG.equals(elementName))
        {
            _connection = _connection.withHost(value);
        }
        else if(DatabaseConnectionSpecification.PORT_TAG.equals(elementName))
        {
            _connection = _connection.withPort(value);
        }
        else if(DatabaseConnectionSpecification.DB_TAG.equals(elementName))
        {
            _connection = _connection.withDatabase(value);
        }
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(String elementName, Attributes attr) throws XMLReaderException
    {
        if(DatabaseConnectionSpecification.PROP_TAG.equals(elementName))
        {
            _properties = new Properties(DatabaseConnectionSpecification.PROP_TAG);
            return _properties.getReader();
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        _connection = _connection.withProperties(_properties);
        _properties = null;
    }

}
