package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;


public class DbTable
{
    private final String _tableName;
    private final Database _database;
    
    public DbTable(Database db, String table)
    {
        _tableName = table;
        _database = db;
    }
    
    public String getTableName()
    {
        return _tableName;
    }
    
    public Connection getConnection()
    {
        return _database.getConnection();
    }
    
    protected ResultSet select(String where) throws SQLException
    {
        String statement = "SELECT * FROM " + _tableName + " " + where;
        return _database.ensureConnection().createStatement().executeQuery(statement);
    }
    
    public void delete(String where) throws SQLException
    {
        String statement = "DELETE FROM " + _tableName + " " + where;
        _database.getConnection().createStatement().executeUpdate(statement);
    }
}
