package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import static com.google.common.collect.Lists.newArrayList;
import static ohd.hseb.hefs.utils.tools.ListTools.mapToArrayList;
import static ohd.hseb.hefs.utils.tools.SupplierTools.getFromSupplierOf;

import java.util.Collection;
import java.util.List;

import ohd.hseb.hefs.mefp.sources.rfcfcst.PedtsepCode;
import ohd.hseb.hefs.mefp.sources.rfcfcst.VfyPairPedtsepCode;
import ohd.hseb.hefs.mefp.sources.rfcfcst.VfyPairPedtsepCode.Reader;
import ohd.hseb.hefs.pe.tools.LocationIdentifier;
import ohd.hseb.hefs.utils.effect.Effect;
import ohd.hseb.hefs.utils.tools.ListTools;
import ohd.hseb.hefs.utils.xml.CollectionXMLWriter;
import ohd.hseb.hefs.utils.xml.ListXMLReader;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class VfyPairFilter implements XMLReader, XMLWriter
{
    public static final String XML_TAG_NAME = "vfyPairFilter";

    private LocationIdentifier _locationId;
    private List<VfyPairPedtsepCode> _codes = newArrayList();

    public VfyPairFilter()
    {
        _locationId = new LocationIdentifier();
    }

    public VfyPairFilter(final String locationId, final PedtsepCode... codes)
    {
        _locationId = new LocationIdentifier(locationId);
        for(final PedtsepCode code: codes)
        {
            _codes.add(VfyPairPedtsepCode.make(code));
        }
    }

    public VfyPairFilter(final String locationId, final VfyPairPedtsepCode... codes)
    {
        _locationId = new LocationIdentifier(locationId);
        _codes = ListTools.concat(codes);
    }

    public VfyPairFilter(final String locationId, final Collection<VfyPairPedtsepCode> codes)
    {
        _locationId = new LocationIdentifier(locationId);
        _codes = newArrayList();
        _codes.addAll(codes);
    }

    public String getLocationId()
    {
        return _locationId.getId();
    }

    public void setLocation(final String locationId)
    {
        _locationId = new LocationIdentifier(locationId);
    }

    public List<VfyPairPedtsepCode> getCodes()
    {
        return _codes;
    }

    @Override
    public boolean equals(final Object other)
    {
        if(!(other instanceof VfyPairFilter))
        {
            return false;
        }
        final VfyPairFilter o = (VfyPairFilter)other;
        return _locationId.equals(o._locationId) && ListTools.twoSidedListCheck(_codes, o._codes);
    }

    @Override
    public int hashCode()
    {
        int hash = _locationId.hashCode();
        for(final VfyPairPedtsepCode code: _codes)
        {
            hash ^= code.hashCode();
        }
        return hash;
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        final Element elt = request.createElement(getXMLTagName());
        elt.appendChild(_locationId.writePropertyToXMLElement(request));
        elt.appendChild(new CollectionXMLWriter("codes", _codes).writePropertyToXMLElement(request));
        return elt;
    }

    @Override
    public String getXMLTagName()
    {
        return XML_TAG_NAME;
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(_locationId.getXMLTagName().equals(elementName))
        {
            return _locationId;
        }
        else if("codes".equals(elementName))
        {
            final Effect<List<VfyPairPedtsepCode.Reader>> addCodes = new Effect<List<VfyPairPedtsepCode.Reader>>()
            {
                @Override
                public void perform(final List<Reader> input)
                {
                    _codes.addAll(mapToArrayList(getFromSupplierOf(VfyPairPedtsepCode.class), input));
                }
            };
            return new ListXMLReader("codes", VfyPairPedtsepCode.Reader.FACTORY, addCodes);
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }
}
