package ohd.hseb.hefs.mefp.sources.rfcfcst.database;

import java.sql.SQLException;

import ohd.hseb.hefs.mefp.sources.rfcfcst.VfyPairSet;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLReaderFactory;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.XMLWriterException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/**
 * Specifies a source for reading in VfyPairs.
 * 
 * @author alexander.garbarino
 */
public class VfyPairSource implements XMLReader, XMLWriter
{
    public static final XMLReaderFactory<VfyPairSource> DEFAULT_FACTORY = new XMLReaderFactory<VfyPairSource>()
    {
        @Override
        public VfyPairSource get()
        {
            return new VfyPairSource();
        }
    };

    private boolean _ready;
    private DatabaseConnectionSpecification _connection;
    private final VfyPairFilter _filter;

    private DatabaseConnectionSpecificationReader _connectionReader;

    public VfyPairSource()
    {
        _ready = false;
        _connection = new DatabaseConnectionSpecification();
        _filter = new VfyPairFilter();
    }

    public VfyPairSource(final DatabaseConnectionSpecification connection, final VfyPairFilter filter)
    {
        _connection = connection;
        _filter = filter;
        _ready = true;
    }

    private void assertReady()
    {
        if(!_ready)
        {
            throw new IllegalStateException("This source not specified.");
        }
    }

    public DatabaseConnectionSpecification getConnection()
    {
        assertReady();
        return _connection;
    }

    public VfyPairFilter getFilter()
    {
        assertReady();
        return _filter;
    }

    public void setConnection(final DatabaseConnectionSpecification conn)
    {
        _connection = conn;
    }

    public void setLocation(final String locationId)
    {
        _filter.setLocation(locationId);
    }

    @Override
    public boolean equals(final Object other)
    {
        if(!(other instanceof VfyPairSource))
        {
            return false;
        }
        final VfyPairSource o = (VfyPairSource)other;
        return _connection.equals(o._connection) && _filter.equals(o._filter);
    }

    @Override
    public int hashCode()
    {
        return _connection.hashCode() ^ _filter.hashCode();
    }

    /**
     * Gets the pairs specified by this source.
     * 
     * @return the pair set of all pairs specified by this source
     * @throws SQLException if an underlying sql error occurs
     */
    public VfyPairSet getPairs() throws SQLException
    {
        assertReady();
        final Database db = new Database(_connection);
        final VfyPairsTable table = new VfyPairsTable(db);
        return new VfyPairSet(table.selectPairs(_filter));
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        return new CompositeXMLWriter(getXMLTagName(), _connection, _filter).writePropertyToXMLElement(request);
    }

    @Override
    public String getXMLTagName()
    {
        return "vfyPairSource";
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
    }

    @Override
    public XMLReader readInPropertyFromXMLElement(final String elementName, final Attributes attr) throws XMLReaderException
    {
        if(_connection.getXMLTagName().equals(elementName))
        {
            _connectionReader = new DatabaseConnectionSpecificationReader();
            return _connectionReader;
        }
        else if(_filter.getXMLTagName().equals(elementName))
        {
            return _filter;
        }
        return null;
    }

    @Override
    public void finalizeReading() throws XMLReaderException
    {
        _ready = true;
        _connection = _connectionReader.get();
    }

    @Override
    public void validate() throws XMLReaderException
    {
    }

    @Override
    public XMLReader getReader()
    {
        return this;
    }

    @Override
    public XMLWriter getWriter()
    {
        return this;
    }

}
