package ohd.hseb.hefs.mefp.tools;

import ohd.hseb.hefs.utils.ftp.SFTPConductor;
import ohd.hseb.hefs.utils.ftp.SFTPSettings;
import ohd.hseb.hefs.utils.xml.XMLReaderException;
import ohd.hseb.hefs.utils.xml.XMLTools;
import ohd.hseb.hefs.utils.xml.XMLWriterException;
import ohd.hseb.util.misc.HString;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MEFPPESFTPSettings extends SFTPSettings
{
    private String _baseDirectoryOnServer;

    public MEFPPESFTPSettings(final String xmlTagName, final String server, final String baseDirectory)
    {
        super(xmlTagName, server);
        _baseDirectoryOnServer = baseDirectory;
    }

    @Override
    public SFTPConductor startFTPSession() throws Exception
    {
        return new SFTPConductor(this);
    }

    /**
     * Overridden to add an MEFPPE specific message indicating to check the run area .systemFiles.
     */
    @Override
    public void checkSettings() throws Exception
    {
        try
        {
            super.checkSettings();
        }
        catch(final Exception e)
        {
            final Exception newE = new Exception(e.getMessage()
                + " Does the SFTP settings file exist within the mefppeRunArea/.systemFiles directory and include correct settings?");
            newE.setStackTrace(e.getStackTrace());
            throw newE;
        }
    }

    public String getBaseDirectoryOnServer()
    {
        return _baseDirectoryOnServer;
    }

    public void setBaseDirectoryOnServer(final String baseDirectory)
    {
        this._baseDirectoryOnServer = baseDirectory;
    }

    @Override
    public void setValueOfElement(final String elementName, final String value) throws XMLReaderException
    {
        if(elementName.equals("baseDirectoryOnServer"))
        {
            this._baseDirectoryOnServer = value;
        }
        super.setValueOfElement(elementName, value);
    }

    @Override
    public Element writePropertyToXMLElement(final Document request) throws XMLWriterException
    {
        final Element mainElement = super.writePropertyToXMLElement(request);
        mainElement.appendChild(XMLTools.createTextNodeElement(request,
                                                               "baseDirectoryOnServer",
                                                               getBaseDirectoryOnServer()));
        return mainElement;
    }

    @Override
    public boolean equals(final Object obj)
    {
        final MEFPPESFTPSettings other = (MEFPPESFTPSettings)obj;
        return (super.equals(other) && (_baseDirectoryOnServer.equals(other.getBaseDirectoryOnServer())));
    }

    @Override
    public String toString()
    {
        return "MEFPPEFTPSettings: xmlTagName = '" + getXMLTagName() + "'; serverName = '" + getServerName()
            + "'; backupServerNames = " + HString.buildStringFromList(getBackupServerNames(), ",") + "; userName = '"
            + getUserName() + "'; password = '" + getPassword() + "'; baseDirectoryonServer = '"
            + _baseDirectoryOnServer + ".";
    }

}
