package ohd.hseb.hefs.mefp.tools;

import javax.swing.Icon;

import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.tools.IconTools;

public enum QuestionableStatus implements StatusIndicator
{
    QUESTIONABLE(null, "yellowQuestion", "The data has missing or extreme values."); /* \n */

    private final Boolean _boolean;
    private final Icon _icon;
    private final String _description;

    private QuestionableStatus(final Boolean b, final String iconName, final String description)
    {
        _boolean = b;
        _icon = IconTools.getHSEBIcon(iconName);
        _description = description;
    }

    @Override
    public boolean isReady()
    {
        return true;
    }

    @Override
    public boolean exists()
    {
        return true;
    }

    @Override
    public boolean canBePrepared()
    {
        return true;
    }

    @Override
    public Icon getIcon()
    {
        return _icon;
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public Boolean toBoolean()
    {
        return _boolean;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return true;
    }
}
