package ohd.hseb.hefs.mefp.tools.canonical;

import ohd.hseb.hefs.mefp.models.MEFPEnsembleGeneratorModel;
import ohd.hseb.hefs.mefp.sources.MEFPForecastSource;

/**
 * Can be provided to an {@link MEFPEnsembleGeneratorModel} in order to restrict which canonical events are used.
 * 
 * @author hankherr
 */
public interface CanonicalEventRestrictor
{
    /**
     * @return True if the event should be used or fase otherwise. This is typically determined based on run-time
     *         options.
     */
    public boolean useEvent(MEFPForecastSource source, CanonicalEvent event);
}
