package ohd.hseb.hefs.mefp.tools.canonical;

public enum CanonicalEventType
{
    BASE("Base"), MODULATION("Modulation"), BOTH("Both");

    private String _name;

    CanonicalEventType(String name)
    {
        _name = name;
    }

    @Override
    public String toString()
    {
        return _name;
    }

    /**
     * Returns the canonical event with the (case insensitive) given name, or null if there is none.
     * 
     * @param s the name of the event
     * @return the given event or null
     */
    public static CanonicalEventType forName(String s)
    {
        if(s == null)
        {
            return null;
        }
        for(CanonicalEventType type: CanonicalEventType.values())
        {
            if(s.equalsIgnoreCase(type._name))
            {
                return type;
            }
        }
        return null;
    }
}
