package ohd.hseb.hefs.mefp.unused;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelListener;

import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifierList;
import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.TableTools;
import ohd.hseb.hefs.utils.gui.jtable.buttons.DeleteSelectedRowsButton;
import ohd.hseb.hefs.utils.gui.jtable.buttons.SelectAllButton;
import ohd.hseb.hefs.utils.gui.jtable.buttons.SelectUnreadyRowsButton;
import ohd.hseb.hefs.utils.gui.jtable.buttons.UnselectAllButton;
import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.MultiItemButton;
import ohd.hseb.hefs.utils.gui.tools.SingleItemButton;
import ohd.hseb.hefs.utils.status.StatusLabel;

import com.google.common.eventbus.EventBus;

public class StationMappingPanel extends JPanel
{
    private static final long serialVersionUID = 1L;
    private GenericTable _mappingTable;
    private StationMappingTableModel _mappingModel;
    private final LocationAndDataTypeIdentifierList _identifiersUsed;

    private CopyButton _copyButton;
    private PasteButton _pasteButton;
    private SelectAllButton _selectAllUnusedButton;
    private UnselectAllButton _clearSelectionButton;
    private SelectUnreadyRowsButton _selectUnusedButton;
    private DeleteSelectedRowsButton _deleteSelectedButton;

    public StationMappingPanel(LocationAndDataTypeIdentifierList identifiers,
                               LocationAndDataTypeIdentifierList identifiersUsed)
    {
        createDisplay();
        _mappingModel.setIdentifiers(identifiers);
        _identifiersUsed = identifiersUsed;
    }

    public void setIdentifiersUsed(LocationAndDataTypeIdentifierList identifiersUsed)
    {
        _identifiersUsed.clear();
        _identifiersUsed.addAll(identifiersUsed);
        _mappingTable.repaint();
    }

    private void createDisplay()
    {
        _mappingModel = new StationMappingTableModel(new IdentifierUsedStatusProvider());
        _mappingTable = new GenericTable(_mappingModel);
        _selectAllUnusedButton = new SelectAllButton(_mappingTable);
        _clearSelectionButton = new UnselectAllButton(_mappingTable);
        _selectUnusedButton = new SelectUnreadyRowsButton(_mappingTable);
        _deleteSelectedButton = new DeleteSelectedRowsButton(_mappingTable, _mappingModel);
        _mappingTable.setToolTipText("<html>This table allows for instructing the MEFPPE to use another location id<br>to identify which forecast-observed pairs to use.</html>");
        JScrollPane scrollPane = new JScrollPane(_mappingTable);
        scrollPane.setBorder(HSwingFactory.createTitledBorder(BorderFactory.createEtchedBorder(1),
                                                              "Map Location ID To Another Location ID (Synthetic Station ID)",
                                                              null));
        _mappingTable.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        _mappingTable.setAutoCreateRowSorter(true);

        _copyButton = new CopyButton();
        _pasteButton = new PasteButton(_copyButton);
        JToolBar buttonBar = new JToolBar();
        buttonBar.add(_selectAllUnusedButton);
        buttonBar.add(_clearSelectionButton);
        buttonBar.add(_selectUnusedButton);
        buttonBar.addSeparator();
        buttonBar.add(_deleteSelectedButton);
        buttonBar.add(_copyButton);
        buttonBar.add(_pasteButton);
        buttonBar.add(new JPanel());
        buttonBar.setFloatable(false);

        EventBus rowBus = _mappingTable.getRowSelectionBus();
        rowBus.register(_copyButton);
        rowBus.register(_pasteButton);

        setLayout(new BorderLayout());
        add(scrollPane, BorderLayout.CENTER);
        add(buttonBar, BorderLayout.SOUTH);
    }

    protected void addTableModelListener(TableModelListener listener)
    {
        this._mappingModel.addTableModelListener(listener);
    }

    @SuppressWarnings("serial")
    private class CopyButton extends SingleItemButton
    {
        private String _copiedLocationId = null;
        private double _copiedLat = Double.NaN;
        private double _copiedLon = Double.NaN;

        public CopyButton()
        {
            super("copySelectedRow20x20", "Copy the Mapped Location Information");
        }

        public void pasteTo(LocationAndDataTypeIdentifier identifier)
        {
            if(_copiedLocationId != null)
            {
                identifier.setMappedLocationId(_copiedLocationId);
                identifier.setMappedLocationLatitude(_copiedLat);
                identifier.setMappedLocationLongitude(_copiedLon);
            }
        }

        public boolean canPaste()
        {
            return _copiedLocationId != null;
        }

        @Override
        public void actionPerformed(ActionEvent e)
        {
            int row = _mappingTable.getSelectedRow();
            LocationAndDataTypeIdentifier identifier = _mappingModel.getIdentifier(row);
            _copiedLocationId = identifier.getMappedLocationId();
            _copiedLat = identifier.getMappedLocationLatitude();
            _copiedLon = identifier.getMappedLocationLongitude();
            TableTools.reselectRows(_mappingTable);
        }
    }

    @SuppressWarnings("serial")
    private class PasteButton extends MultiItemButton
    {
        public PasteButton(CopyButton copyButton)
        {
            super("pasteSelectedRow20x20", "Paste the Copied Mapped Location Info to Selected Rows");
            _copyButton = copyButton;
        }

        @Override
        public void actionPerformed(ActionEvent e)
        {
            int[] rows = _mappingTable.getSelectedRows();

            for(int row: rows)
            {
                LocationAndDataTypeIdentifier identifier = _mappingModel.getIdentifier(row);
                _copyButton.pasteTo(identifier);
            }

            _mappingModel.fireTableDataChanged();
        }

        @Override
        public void setEnabled(boolean b)
        {
            //This will get called before _copyButton is set, so check for null.
            if((_copyButton == null) || (!_copyButton.canPaste()))
            {
                super.setEnabled(false);
            }
            else
            {
                super.setEnabled(b);
            }
        }
    }

    private class IdentifierUsedStatusProvider implements GenericSummaryTableStatusProvider
    {
        @Override
        public String getStatusColumnName()
        {
            return "Used?";
        }

        @Override
        public String getToolTipForColumnHeader()
        {
            return "Indicates if the location and data type are used by the MEFPPE (i.e., have historical data available)";
        }

        @Override
        public StatusLabel getStatus(LocationAndDataTypeIdentifier identifier)
        {
            if(_identifiersUsed.contains(identifier))
            {
                return StatusLabel.make(true,
                                        "<html>Historical data exists for " + identifier.buildStringToDisplayInTree()
                                            + "<br>so that parameters can be estimated.</html>");
            }
            else
            {
                return StatusLabel.make(false,
                                        "<html>Historical data does not exist for "
                                            + identifier.buildStringToDisplayInTree()
                                            + "<br> so that parameters cannot be estimated.</html>");
            }
        }

    }
}
