package ohd.hseb.hefs.mefp.unused;

import java.util.Arrays;

import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifierList;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteRowTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteTableModelWrapper;
import ohd.hseb.hefs.utils.status.StatusLabel;

@SuppressWarnings("serial")
public class StationMappingTableModel extends AddDeleteTableModelWrapper
{
    private static final String DEL_STR = "Remove Unused Station Mapping";
    public static String NO_MAPPED_STATION_ID = "-none-";

    public StationMappingTableModel(final GenericSummaryTableStatusProvider statusProvider)
    {
        super(new InnerTableModel(statusProvider), DEL_STR);
    }

    public void setIdentifiers(final LocationAndDataTypeIdentifierList selectedIdentifiers)
    {
        ((InnerTableModel)this.getDelegate()).setIdentifiers(selectedIdentifiers);
    }

    public LocationAndDataTypeIdentifier getIdentifier(final int row)
    {
        return ((InnerTableModel)this.getDelegate()).getIdentifier(row);
    }

    private static class InnerTableModel extends DefaultTableModel implements AddDeleteRowTableModel
    {
        private static final long serialVersionUID = 1L;

        private LocationAndDataTypeIdentifierList _identifiers;

        private final GenericSummaryTableStatusProvider _statusProvider;

        public InnerTableModel(final GenericSummaryTableStatusProvider statusProvider)
        {
            _statusProvider = statusProvider;
        }

        public void setIdentifiers(final LocationAndDataTypeIdentifierList selectedIdentifiers)
        {
            _identifiers = selectedIdentifiers;
        }

        public LocationAndDataTypeIdentifier getIdentifier(final int row)
        {
            return this._identifiers.get(row);
        }

        @Override
        public int getRowCount()
        {
            if(_identifiers == null)
            {
                return 0;
            }
            return _identifiers.size();
        }

        @Override
        public int getColumnCount()
        {
            return 8;
        }

        @Override
        public String getColumnName(final int column)
        {
            if(column == 0)
            {
                return "Location ID";
            }
            else if(column == 1)
            {
                return "Parameter ID";
            }
            else if(column == 2)
            {
                return "Latitude";
            }
            else if(column == 3)
            {
                return "Longitude";
            }
            else if(column == 4)
            {
                return "Mapped Station ID";
            }
            else if(column == 5)
            {
                return "Mapped Lat";
            }
            else if(column == 6)
            {
                return "Mapped Lon";
            }
            else if(column == 7)
            {
                return _statusProvider.getStatusColumnName();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(final int row, final int column)
        {
            if(column == 4)
            {
                return true;
            }
            if((column == 5) || (column == 6))
            {
                return _identifiers.get(row).isMappedLocationSpecified();
            }
            return false;
        }

        @Override
        public Object getValueAt(final int row, final int column)
        {
            if(column == 0)
            {
                return this._identifiers.get(row).getLocationId();
            }
            else if(column == 1)
            {
                return this._identifiers.get(row).getParameterId();
            }
            else if(column == 2)
            {
                return this._identifiers.get(row).getLocationLatitude();
            }
            else if(column == 3)
            {
                return this._identifiers.get(row).getLocationLongitude();
            }
            else if(column == 4)
            {
                if(_identifiers.get(row).getMappedLocationId() == null)
                {
                    return NO_MAPPED_STATION_ID;
                }
                return _identifiers.get(row).getMappedLocationId();
            }
            else if(column == 5)
            {
                if(Double.isNaN(_identifiers.get(row).getMappedLocationLatitude()))
                {
                    return -999d;
                }
                return _identifiers.get(row).getMappedLocationLatitude();
            }
            else if(column == 6)
            {
                if(Double.isNaN(_identifiers.get(row).getMappedLocationLongitude()))
                {
                    return -999d;
                }
                return _identifiers.get(row).getMappedLocationLongitude();
            }
            else if(column == 7)
            {
                return _statusProvider.getStatus(_identifiers.get(row));
            }
            return null;
        }

        private LocationAndDataTypeIdentifier findAnotherIdentifierThatUsesSameMapping(final LocationAndDataTypeIdentifier base)
        {
            if(base.getMappedLocationId() == null)
            {
                return null;
            }
            for(final LocationAndDataTypeIdentifier identifier: _identifiers)
            {
                if((!base.equals(identifier)) && (base.getMappedLocationId().equals(identifier.getMappedLocationId())))
                {
                    return identifier;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(final Object aValue, final int row, final int column)
        {
            if(column == 4)
            {
                final String newMapping = (String)aValue;
                final LocationAndDataTypeIdentifier identifierForSelectedLocation = _identifiers.get(row);
                final String previousUsedId = identifierForSelectedLocation.getUsedLocationId();
                if(!previousUsedId.equals(newMapping))
                {
                    final String locationId = identifierForSelectedLocation.getLocationId();
                    if((newMapping.equals(NO_MAPPED_STATION_ID)) || (newMapping.isEmpty())
                        || (newMapping.equals(locationId)))
                    {
                        identifierForSelectedLocation.clearSyntheticLocationId();
                    }
                    else
                    {
                        identifierForSelectedLocation.setMappedLocation(newMapping, 0.0D, 0.0D);
                        final LocationAndDataTypeIdentifier other = findAnotherIdentifierThatUsesSameMapping(identifierForSelectedLocation);
                        if(other != null)
                        {
                            identifierForSelectedLocation.setMappedLocationLatitude(other.getMappedLocationLatitude());
                            identifierForSelectedLocation.setMappedLocationLongitude(other.getMappedLocationLongitude());
                        }
                    }
                    fireTableDataChanged();
                }
            }
            else if(column == 5)
            {
                try
                {
                    Double value;
                    if(aValue instanceof Double)
                    {
                        value = (Double)aValue;
                    }
                    else if(aValue instanceof String)
                    {
                        final String valueStr = (String)aValue;
                        value = Double.parseDouble(valueStr);
                    }
                    else if(aValue instanceof Number)
                    {
                        value = ((Number)aValue).doubleValue();
                    }
                    else
                    {
                        throw new NumberFormatException();
                    }

                    final LocationAndDataTypeIdentifier identifierForSelectedLocation = _identifiers.get(row);
                    identifierForSelectedLocation.setMappedLocationLatitude(value);
                    for(final LocationAndDataTypeIdentifier identifier: _identifiers)
                    {
                        if(identifierForSelectedLocation.getMappedLocationId().equals(identifier.getMappedLocationId()))
                        {
                            identifier.setMappedLocationLatitude(value);
                        }
                    }
                    fireTableDataChanged();
                }
                catch(final NumberFormatException e)
                {
                    JOptionPane.showMessageDialog(null,
                                                  "Specified latitude is not a number.",
                                                  "Error Setting Mapped Latitude",
                                                  JOptionPane.ERROR_MESSAGE);
                }
            }
            else if(column == 6)
            {
                try
                {
                    Double value;
                    if(aValue instanceof Double)
                    {
                        value = (Double)aValue;
                    }
                    else if(aValue instanceof String)
                    {
                        final String valueStr = (String)aValue;
                        value = Double.parseDouble(valueStr);
                    }
                    else if(aValue instanceof Number)
                    {
                        value = ((Number)aValue).doubleValue();
                    }
                    else
                    {
                        throw new NumberFormatException();
                    }

                    final LocationAndDataTypeIdentifier identifierForSelectedLocation = _identifiers.get(row);
                    identifierForSelectedLocation.setMappedLocationLongitude(value);
                    for(final LocationAndDataTypeIdentifier identifier: _identifiers)
                    {
                        if(identifierForSelectedLocation.getMappedLocationId().equals(identifier.getMappedLocationId()))
                        {
                            identifier.setMappedLocationLongitude(value);
                        }
                    }
                    fireTableDataChanged();
                }
                catch(final NumberFormatException e)
                {
                    JOptionPane.showMessageDialog(null,
                                                  "Specified longitude is not a number.",
                                                  "Error Setting Mapped Latitude",
                                                  JOptionPane.ERROR_MESSAGE);
                }
            }
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex)
        {
            if((columnIndex == 2) || (columnIndex == 3) || (columnIndex == 5) || (columnIndex == 6))
            {
                return Double.class;
            }
            if(columnIndex == 7)
            {
                return StatusLabel.class;
            }
            return String.class;
        }

        @Override
        public void addRow()
        {
            //DO NOTHING! -- this table does not include an add row!
        }

        @Override
        public void deleteRow(final int indexOfRowClicked, int[] allTableSelectedIndices)
        {
            //A -1 indicates that the delete selected button was clicked.  If it is not -1, then
            //we only allow a single row to be deleted.
            if(indexOfRowClicked >= 0)
            {
                allTableSelectedIndices = new int[1];
                allTableSelectedIndices[0] = indexOfRowClicked;
            }
            else
            {
                Arrays.sort(allTableSelectedIndices);
            }

            //Only allow for removing false rows
            for(int i = allTableSelectedIndices.length - 1; i >= 0; i--)
            {
                if(!_statusProvider.getStatus(_identifiers.get(allTableSelectedIndices[i])).toBoolean())
                {
                    _identifiers.remove(allTableSelectedIndices[i]);
                    fireTableDataChanged();
                }
            }
        }
    }
}
