package ohd.hseb.hefs.pe.acceptance;

import java.io.File;
import java.util.List;

import ohd.hseb.hefs.pe.core.GenericParameterEstimatorStepProcessor;
import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.core.ParameterEstimatorStepOptionsPanel;
import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.status.StatusIndicator;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;

public class AcceptancePEStepProcessor extends GenericParameterEstimatorStepProcessor
{
    private static final Logger LOG = LogManager.getLogger(AcceptancePEStepProcessor.class);

    private final ParameterEstimatorRunInfo _runInformation;

    public AcceptancePEStepProcessor(final ParameterEstimatorRunInfo runInfo)
    {
        _runInformation = runInfo;
    }

    public ParameterEstimatorRunInfo getRunInfo()
    {
        return _runInformation;
    }

    public AcceptedParameterFileHandler getZipFileHandler()
    {
        return _runInformation.getAcceptedZipFileHandler();
    }

    @Override
    public StatusIndicator getStatus(final StepUnit unit)
    {
        return _runInformation.getAcceptedZipFileHandler().getZipStatus(unit);
    }

    @Override
    public void performStep(final StepUnit unit) throws Exception
    {
        if(unit instanceof LocationAndDataTypeIdentifier)
        {
            //TODO Instead of working with zip groups, this will need to do file copies: just copy the files pointed to by the
            //_runInformation.getEstimatedParametersFileHandler() for the unit to the location under mefpRootDir.

            if(getRunInfo().getZipGroupInfo().forIdentifier((LocationAndDataTypeIdentifier)unit).isEmpty())
            {
                throw new Exception("Location " + ((LocationAndDataTypeIdentifier)unit).buildStringToDisplayInTree()
                    + " has not been added to any groups.");
            }
        }

        final List<File> filesAffected = getZipFileHandler().prepareZipFiles(unit);
        for(final File file: filesAffected)
        {
            LOG.info("Created or modified file " + file.getAbsolutePath());
        }
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return new AcceptancePEStepOptionsPanel(_runInformation, this);
    }

    @Override
    public String getToolTipTextDescribingStep()
    {
        return "Examine and accept estimated parameters but zipping and placing them under Config/ModuleParFiles/hefs.";
    }

    @Override
    public String getTabNameForStep()
    {
        return "Acceptance";
    }

    @Override
    public String getStepNameForRunButton()
    {
        return "Accept Selected";
    }

    @Override
    public String getShortNameForIdentifierTableColumn()
    {
        return "Accept";
    }

    @Override
    public String getToolTipTextForIdentifierTableColumnHeader()
    {
        //Different mechanism is used for acceptance zip tables.
        return "<html>Displays if the parameter files for an identifier and data type<BR> have been zipped into the group zip files</html>";
    }

    @Override
    public String getPerformStepPrefix()
    {
        return "Zipping parameters";
    }

}
