package ohd.hseb.hefs.pe.acceptance;

import javax.swing.Icon;

import ohd.hseb.charter.translator.plugins.ComparableTools;
import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.tools.IconTools;

import com.google.common.collect.Sets;

public enum IdentifierZipStatus implements StatusIndicator
{
    COMPLETE("checkMark", "The parameter files for this identifier have been prepared for all specified groups."), /**/
    NEEDS_UPDATE("yellowExclamation",
    "The parameter files for this identifier need to be updated for one or more group zip files."), /**/
    MISSING_FILES_IN_ZIPS("yellowExclamation",
    "The parameter files for this identifier are absent from one or more group zip files."), /**/
    NO_ASSIGNED_GROUPS("yellowExclamation", "Required files exist, but identifier has not been assigned to any groups."), /**/
    MISSING_COMPONENTS_ON_FILE_SYSTEM("redX", "Zip group cannot be zipped: some required parameter files are missing."), /**/
    ERROR("redX", "There was an error reading the group zip files.");

    private final Icon _icon;
    private final String _description;

    private IdentifierZipStatus(final String iconName, final String description)
    {
        _icon = IconTools.getHSEBIcon(iconName);
        _description = description;
    }

    public IdentifierZipStatus worse(final IdentifierZipStatus other)
    {
        return ComparableTools.max(this, other);
    }

    @Override
    public Boolean toBoolean()
    {
        if(isReady())
        {
            return true;
        }
        else if(exists())
        {
            return null;
        }
        else
        {
            return false;
        }
    }

    @Override
    public boolean canBePrepared()
    {
        return !Sets.newHashSet(ERROR, MISSING_COMPONENTS_ON_FILE_SYSTEM).contains(this);
    }

    @Override
    public boolean isReady()
    {
        return this.equals(COMPLETE);
    }

    @Override
    public boolean exists()
    {
        return this.equals(COMPLETE) || this.equals(NEEDS_UPDATE);
    }

    @Override
    public Icon getIcon()
    {
        return _icon;
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return true;
    }
}
