package ohd.hseb.hefs.pe.acceptance.group;

import javax.swing.JOptionPane;
import javax.swing.JTable;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.models.AbstractToolTipTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteRowTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.AddDeleteTableModelWrapper;
import ohd.hseb.hefs.utils.gui.jtable.models.PreferredWidthsTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.TableAwareTableModel;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.notify.collect.CollectionModifiedNotice;

import com.google.common.collect.Iterables;
import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class GroupListTableModel extends AddDeleteTableModelWrapper
{
    private static final String ADD_MSG = "Create a new zip group.";
    private static final String DEL_MSG = "Remove this zip group.";

    public GroupListTableModel(ZipGroupInfo groupCollection)
    {
        super(new InnerModel(groupCollection), ADD_MSG, DEL_MSG);
    }

    private static class InnerModel extends AbstractToolTipTableModel implements AddDeleteRowTableModel,
    TableAwareTableModel, PreferredWidthsTableModel, CollectionModifiedNotice.Subscriber
    {
        private final ZipGroupInfo _groups;

        private JTable _table;

        private InnerModel(ZipGroupInfo groupCollection)
        {
            _groups = groupCollection;
            _groups.register(this);
        }

        @Override
        public int getRowCount()
        {
            return _groups.size();
        }

        @Override
        public int getColumnCount()
        {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex)
        {
            return "Group";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex)
        {
            return ZipGroup.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex)
        {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex)
        {
            return Iterables.get(_groups, rowIndex);
        }

        @Override
        public void addRow()
        {
            //Add groups until one works.  A group is only added if one does not already exist with its name.
            int nameIndexAdder = 1;
            while(!_groups.addGroupIfNotPresent(new ZipGroup("Group" + nameIndexAdder)))
            {
                nameIndexAdder++;
            }
        }

        @Override
        public void deleteRow(int indexOfRowClicked, int[] allTableSelectedIndices)
        {
            ZipGroup group = Iterables.get(_groups, indexOfRowClicked);
            int option = JOptionPane.showConfirmDialog(SwingTools.getGlobalDialogParent(_table),
                                                       "Are you sure you want to delete the group " + group.getName()
                                                           + "?  Click Yes to delete the group.",
                                                       "Confirm Delete",
                                                       JOptionPane.YES_NO_OPTION);
            if(option == JOptionPane.YES_OPTION)
            {
                _groups.remove(group);
            }
        }

        @Override
        public Integer getPreferredWidth(int column)
        {
            return 100;
        }

        @Override
        @Subscribe
        public void reactToCollectionModified(CollectionModifiedNotice evt)
        {
            //This should only react to events based on ZipGroupInfo (_groups),
            //not the elements of ZipGroupInfo.  Other events, including renaming groups,
            //that come through here should just result in a repainting of the table.
            if(evt.getSource() instanceof ZipGroupInfo)
            {
                this.fireTableDataChanged();
            }
            else
            {
                _table.repaint();
            }
        }

        @Override
        public void addTable(JTable table)
        {
            _table = table;
        }

        @Override
        public void removeTable(JTable table)
        {
            _table = null;
        }
    }

    /**
     * @return A GenericTable for this model which remembers selections when the table is changed.
     */
    public GenericTable makeTable()
    {
        GenericTable table = new GenericTable(this);
        ((InnerModel)this.getDelegate()).addTable(table);
        return table;
    }
}
