package ohd.hseb.hefs.pe.acceptance.group;

import javax.swing.Icon;

import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.tools.IconTools;

public enum GroupZipStatus implements StatusIndicator
{
    COMPLETE(true, "checkMark", "This group is ready."), /**/
    EXTRA_FILES(true, "yellowExclamation", "This group has extra files - please update."), /**/
    NEEDS_UPDATE(true, "yellowExclamation", "This group has out of date files - please update."), /**/
    INCOMPLETE(true, "yellowExclamation", "This group has missing files."), /**/
    INCOMPLETE_NEEDS_UPDATE(true, "yellowExclamation",
    "This group needs to be updated, but cannot be completed because of missing files."), /**/
    MISSING(false, "redX", "This group has not been created."), /**/
    NO_IDENTIFIERS(false, "yellowExclamation", "This group has no identifiers specified."), /**/
    ERROR(false, "redX", "There was an error reading this zip file.");

    private final boolean _exists;
    private final Icon _icon;
    private final String _description;

    private GroupZipStatus(final boolean exists, final String iconName, final String description)
    {
        _exists = exists;
        _icon = IconTools.getHSEBIcon(iconName);
        _description = description;
    }

    @Override
    public Boolean toBoolean()
    {
        if(isReady())
        {
            return true;
        }
        else if(exists())
        {
            return null;
        }
        else
        {
            return false;
        }
    }

    @Override
    public boolean isReady()
    {
        return this.equals(COMPLETE);
    }

    @Override
    public boolean exists()
    {
        return _exists;
    }

    @Override
    public boolean canBePrepared()
    {
        return !this.equals(ERROR);
    }

    @Override
    public Icon getIcon()
    {
        return _icon;
    }

    @Override
    public String getDescription()
    {
        return _description;
    }

    @Override
    public boolean includeInRowReadinessCheck()
    {
        return true;
    }

}
