package ohd.hseb.hefs.pe.acceptance.group;

import java.util.List;
import java.util.TreeSet;

import ohd.hseb.hefs.pe.core.StepUnit;
import ohd.hseb.hefs.pe.notice.ZipGroupRenamedGroupNotice;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifierSupplier;
import ohd.hseb.hefs.utils.effect.Effect;
import ohd.hseb.hefs.utils.notify.collect.NotifyingCollectionWrapper;
import ohd.hseb.hefs.utils.xml.CollectionXMLWriter;
import ohd.hseb.hefs.utils.xml.CompositeXMLReader;
import ohd.hseb.hefs.utils.xml.CompositeXMLWriter;
import ohd.hseb.hefs.utils.xml.ListXMLReader;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLReaderFactory;
import ohd.hseb.hefs.utils.xml.XMLWritable;
import ohd.hseb.hefs.utils.xml.XMLWriter;
import ohd.hseb.hefs.utils.xml.vars.XMLString;

public class ZipGroup
extends
    NotifyingCollectionWrapper<LocationAndDataTypeIdentifier, TreeSet<LocationAndDataTypeIdentifier>> implements
XMLReadable, XMLWritable, StepUnit
{
    public static final String XML_TAG = "zipGroup";
    public static final XMLReaderFactory<ZipGroup> DEFAULT_FACTORY = new DefaultFactory();

    private XMLString _name;

    public ZipGroup()
    {
        super(new TreeSet<LocationAndDataTypeIdentifier>());
        _name = new XMLString("name");
    }

    public ZipGroup(String name)
    {
        super(new TreeSet<LocationAndDataTypeIdentifier>());
        _name = new XMLString("name", name);
    }

    public String getName()
    {
        return _name.get();
    }

    public void setName(String name)
    {
        setName(name, null);
    }

    public void setName(String name, Object source)
    {
        String oldName = _name.toString();
        _name = new XMLString("name", name);
        post(new ZipGroupRenamedGroupNotice(source, this, oldName));
    }

//XXX This is being commented out for now.  It may be needed for future testing of a possible
//multithreading/sync issue when these notifications are passed out after zipping a group.
//    public void notifyPrepared(Object source)
//    {
//        post(new ZipGroupPreparedGroupNotice(source, this));
//    }

    @Override
    public XMLWriter getWriter()
    {
        return new CompositeXMLWriter(getXMLTagName(), _name, new CollectionXMLWriter("identifiers", this));
    }

    public String getXMLTagName()
    {
        return XML_TAG;
    }

    @Override
    public XMLReader getReader()
    {
        Effect<List<LocationAndDataTypeIdentifierSupplier>> addIdentifiers;
        addIdentifiers = new Effect<List<LocationAndDataTypeIdentifierSupplier>>()
        {
            @Override
            public void perform(List<LocationAndDataTypeIdentifierSupplier> input)
            {
                for(LocationAndDataTypeIdentifierSupplier supplier: input)
                {
                    ZipGroup.this.add(supplier.get());
                }
            }
        };

        return new CompositeXMLReader(getXMLTagName(),
                                      _name,
                                      new ListXMLReader("identifiers",
                                                        LocationAndDataTypeIdentifierSupplier.DEFAULT_FACTORY,
                                                        addIdentifiers));
    }

    @Override
    public String getMessageName()
    {
        return toString();
    }

    @Override
    public String toString()
    {
        return _name.get();
    }

    private static class DefaultFactory implements XMLReaderFactory<ZipGroup>
    {
        @Override
        public ZipGroup get()
        {
            return new ZipGroup();
        }

    }
}
