package ohd.hseb.hefs.pe.core;

import java.awt.Component;
import java.util.List;

import javax.swing.JLabel;

import ohd.hseb.hefs.utils.status.NullStatusIndicator;
import ohd.hseb.hefs.utils.status.StatusIndicator;
import ohd.hseb.hefs.utils.tools.StringTools;

import com.google.common.base.Joiner;

/**
 * Blank adapter for {@link ParameterEstimatorStepProcessor}. Also implements {@link Object#toString()} in terms of
 * {@link ParameterEstimatorStepProcessor#getStepNameForRunButton()}.
 * 
 * @author alexander.garbarino
 */
public abstract class GenericParameterEstimatorStepProcessor implements ParameterEstimatorStepProcessor
{
    private final StepInfo _info;

    protected GenericParameterEstimatorStepProcessor()
    {
        this(null);
    }

    protected GenericParameterEstimatorStepProcessor(final StepInfo info)
    {
        _info = info;
    }

    @Override
    public ParameterEstimatorStepOptionsPanel constructOptionsPanel()
    {
        return null;
    }

    @Override
    public StatusIndicator getStatus(final StepUnit unit)
    {
        return NullStatusIndicator.INSTANCE;
    }

    @Override
    public void prepareStep(final boolean skipUserInput) throws Exception
    {
    }

    @Override
    public void performStep(final StepUnit unit) throws Exception
    {
    }

    @Override
    public void cleanupAfterStep()
    {
    }

    @Override
    public String getToolTipTextDescribingStep()
    {
        return _info.shortTip;
    }

    @Override
    public String getTabNameForStep()
    {
        return this.getClass().getName();
    }

    @Override
    public String getStepNameForRunButton()
    {
        return this.getClass().getName();
    }

    @Override
    public String getShortNameForIdentifierTableColumn()
    {
        return this.getClass().getName();
    }

    @Override
    public String getToolTipTextForIdentifierTableColumnHeader()
    {
        return _info.longTip;
    }

    @Override
    public String getInstructions()
    {
        return _info.instructions;
    }

    @Override
    public String getPerformStepPrefix()
    {
        return _info.prefix;
    }

    @Override
    public String toString()
    {
        return getTabNameForStep();
    }

    @Override
    public boolean concurrencySupported()
    {
        return false;
    }

    @Override
    public Component constructConfirmRunPanel(final List<? extends StepUnit> units)
    {
        final String allUnitsStr = Joiner.on(", ").join(StepUnits.makeNameList(units));
        final String message = StringTools.wordWrap("The step will be performed for these units: " + allUnitsStr + ".",
                                                    100);
        return new JLabel(StringTools.htmlizeString(message));

    }

}
