package ohd.hseb.hefs.pe.core;

import javax.swing.JPanel;

import ohd.hseb.hefs.pe.notice.ClearDiagnosticNotice;
import ohd.hseb.hefs.pe.notice.DisplayDiagnosticMessageNotice;
import ohd.hseb.hefs.pe.notice.DisplayDiagnosticPanelNotice;

@SuppressWarnings("serial")
public abstract class ParameterEstimatorPanel extends JPanel implements ParameterEstimatorObject
{
    protected abstract void initializeDisplay();

    /**
     * Fires a {@link DisplayDiagnosticPanelNotice} to the run info.
     * 
     * @param diagnostic the panel to display
     */
    protected void fireDiagnostic(ParameterEstimatorDiagnosticPanel diagnostic)
    {
        getRunInfo().post(new DisplayDiagnosticPanelNotice(this, diagnostic));
    }

    /**
     * Fires a {@link DisplayDiagnosticPanelNotice} with the specified message to the run info.
     * 
     * @param header the message header
     * @param body the message body
     */
    protected void fireDiagnostic(String header, String body)
    {
        getRunInfo().post(new DisplayDiagnosticMessageNotice(this, header, body));
    }

    protected void clearDIagnostic()
    {
        getRunInfo().post(new ClearDiagnosticNotice(this));
    }
}
