package ohd.hseb.hefs.pe.core;

import java.util.Collection;
import java.util.List;

import ohd.hseb.hefs.pe.notice.GotoStepAndUnitNotice;
import ohd.hseb.hefs.pe.notice.SelectedIdentifiersChangedNotice;

import com.google.common.eventbus.Subscribe;

/**
 * Implementors of this class are returned by ParameterEstimatorStepProcessor and used within the
 * ParameterEstimatorStepsPanel. They are used to validate forecast source data and specify options for steps to
 * perform.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public abstract class ParameterEstimatorStepOptionsPanel extends ParameterEstimatorSubPanel implements
GotoStepAndUnitNotice.Subscriber, SelectedIdentifiersChangedNotice.Subscriber
{
    protected final ParameterEstimatorStepProcessor _stepProcessor;

    protected ParameterEstimatorStepOptionsPanel(ParameterEstimatorRunInfo runInfo, ParameterEstimatorStepProcessor step)
    {
        super(runInfo);
        runInfo.register(this);
        _stepProcessor = step;
    }

    public ParameterEstimatorStepProcessor getStepProcessor()
    {
        return _stepProcessor;
    }

    /**
     * Call {@link #gotoUnit(StepUnit)} if {@code evt} is for this panel's step.
     */
    @Override
    @Subscribe
    public void reactToGotoStepAndUnit(GotoStepAndUnitNotice evt)
    {
        if(_stepProcessor != null) //May be null; for example, the ExportPIXMLPanel
        {
            if(_stepProcessor.equals(evt.getStep()))
            {
                gotoUnit(evt.getUnits());
            }
        }
    }

    /**
     * Select the specified unit.
     * 
     * @param unit the unit to go to
     */
    protected abstract void gotoUnit(Collection<StepUnit> units);

    /**
     * This is called when the run button is clicked with the units being passed into the
     * ParameterEstimatorStepProcessor performStep method.
     * 
     * @return List of step units for which to perform the step.
     */
    public abstract List<? extends StepUnit> getStepUnitsToPerform();

}
