package ohd.hseb.hefs.pe.core;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import ohd.hseb.hefs.pe.notice.StepUnitsSelectedNotice;
import ohd.hseb.hefs.pe.tools.GenericSummaryTable;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableModel;

/**
 * A table which displays {@link StepUnit}s in one form or another. Meant only to be used with tables which are used to
 * select the performing step.<br>
 * Sends out a {@link StepUnitsSelectedNotice} whenever the selection is changed.
 * 
 * @author alexander.garbarino
 * @param <RowT>
 */
@SuppressWarnings("serial")
public class ParameterEstimatorStepTable<RowT extends StepUnit> extends GenericSummaryTable<RowT>
{
    protected final Class<? extends ParameterEstimatorStepProcessor> _step;

    public ParameterEstimatorStepTable(Class<? extends ParameterEstimatorStepProcessor> step,
                                       GenericSummaryTableModel model)
    {
        super(model);
        _step = step;

        getSelectionModel().addListSelectionListener(new ListSelectionListener()
        {
            @Override
            public void valueChanged(ListSelectionEvent e)
            {
                if(e.getValueIsAdjusting())
                {
                    return;
                }

                post(new StepUnitsSelectedNotice(ParameterEstimatorStepTable.this, _step, getSelectedWholeRows()));
            }
        });

        getSelectionModel().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    }
}
