package ohd.hseb.hefs.pe.core;

import ohd.hseb.hefs.utils.notify.Notice;

/**
 * Super class provides a {@link #getRunInfo()} which returns a {@link ParameterEstimatorRunInfo} method
 * {@link #post(Notice)} method that posts to its bus.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public abstract class ParameterEstimatorSubPanel extends ParameterEstimatorPanel
{
    private final ParameterEstimatorRunInfo _runInfo;

    public ParameterEstimatorSubPanel(ParameterEstimatorRunInfo runInfo)
    {
        _runInfo = runInfo;
        _runInfo.register(this);
    }

    @Override
    public ParameterEstimatorRunInfo getRunInfo()
    {
        return _runInfo;
    }

    public void post(Notice notice)
    {
        _runInfo.post(notice);
    }
}
