package ohd.hseb.hefs.pe.core;

import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.base.Preconditions;

/**
 * A {@link GenericTable} implementation usable by any table in the parameter estimator framework. However, not all
 * table currently use it.
 * 
 * @author hank.herr
 * @param <RowT>
 */
@SuppressWarnings("serial")
public class ParameterEstimatorTable<RowT> extends GenericTable<RowT> implements ParameterEstimatorObject
{
    private final ParameterEstimatorRunInfo _runInfo;

    public ParameterEstimatorTable(ParameterEstimatorRunInfo runInfo)
    {
        _runInfo = runInfo;
    }

    public ParameterEstimatorTable(ParameterEstimatorTableModel model)
    {
        super(model);
        _runInfo = model.getRunInfo();
    }

    @Override
    public ParameterEstimatorTableModel getModel()
    {
        return (ParameterEstimatorTableModel)super.getModel();
    }

    @Override
    public ParameterEstimatorTableModel createDefaultDataModel()
    {
        return new ParameterEstimatorTableModel.Adapter(_runInfo);
    }

    @Override
    public void setModel(TableModel model)
    {
        Preconditions.checkArgument(model instanceof ParameterEstimatorTableModel,
                                    "%s must be an instance of ParameterEstimatorTableModel",
                                    model);
        setModel((ParameterEstimatorTableModel)model);
    }

    public void setModel(ParameterEstimatorTableModel model)
    {
        Preconditions.checkArgument(_runInfo == null || model.getRunInfo() == _runInfo,
                                    "%s has a different run info.",
                                    model);
        super.setModel(model);
    }

    @Override
    public ParameterEstimatorRunInfo getRunInfo()
    {
        return _runInfo;
    }

    protected void post(Notice notice)
    {
        getRunInfo().post(notice);
    }
}
