package ohd.hseb.hefs.pe.core;

import java.util.Set;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

import ohd.hseb.hefs.utils.gui.jtable.models.TableAwareTableModel;
import ohd.hseb.hefs.utils.gui.jtable.models.ToolTipTableModel;
import ohd.hseb.hefs.utils.notify.Notice;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;

/**
 * A {@link AbstractTableModel} that is aware of the tables that display it ({@link TableAwareTableModel}) and the
 * supplies tool tips ({@link ToolTipTableModel}). It also contains a constructor the requires supplying a
 * {@link ParameterEstimatorRunInfo}, a {@link #getRunInfo()} method for that run info, as well as a
 * {@link #post(Notice)} method to post to its {@link EventBus}.
 * 
 * @author hank.herr
 */
@SuppressWarnings("serial")
public abstract class ParameterEstimatorTableModel extends AbstractTableModel implements TableAwareTableModel,
ToolTipTableModel
{
    protected final ParameterEstimatorRunInfo _runInfo;
    protected final Set<JTable> _tables;

    protected ParameterEstimatorTableModel(ParameterEstimatorRunInfo runInfo)
    {
        _runInfo = runInfo;
        if(_runInfo != null)
        {
            _runInfo.register(this);
        }
        _tables = Sets.newHashSet();
    }

    public ParameterEstimatorRunInfo getRunInfo()
    {
        return _runInfo;
    }

    protected void post(Notice notice)
    {
        _runInfo.post(notice);
    }

    protected JTable getTable()
    {
        if(!_tables.isEmpty())
        {
            return _tables.iterator().next();
        }
        return null;
    }

    protected JTable getTable(int index)
    {
        if((index < 0) || (index >= _tables.size()))
        {
            return null;
        }
        return Iterables.get(_tables, index);
    }

    @Override
    public void addTable(JTable table)
    {
        _tables.add(table);
    }

    @Override
    public void removeTable(JTable table)
    {
        _tables.remove(table);
    }

    /**
     * Create a default table for this model.
     * 
     * @return a new table for this model
     */
    public ParameterEstimatorTable createDefaultTable()
    {
        ParameterEstimatorTable table = instantiateDefaultTable();
        initializeTable(table);
        return table;
    }

    /**
     * Internal method to create a new table instance. Should be overridden by subclasses to change the class of table
     * created.
     * 
     * @return a new default table
     */
    protected ParameterEstimatorTable instantiateDefaultTable()
    {
        return new ParameterEstimatorTable(this);
    }

    /**
     * Internal method used to initialize a created table. Should be overridden by subclasses if necessary. By default,
     * selection mode for rows is set to ListSelectionModel.MULTIPLE_INTERVAL_SELECTION and the fillsViewportHeight is
     * set to true.
     * 
     * @param table the table to initialize
     */
    protected void initializeTable(ParameterEstimatorTable table)
    {
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setFillsViewportHeight(true);
    }

    /**
     * A default implementation of {@link ParameterEstimatorTableModel}. Can be accessed via new
     * ParameterEstimatorTableModel.Adapter(ParameterEstimatorRunInfo).
     * 
     * @author hank.herr
     */
    public static class Adapter extends ParameterEstimatorTableModel
    {
        protected Adapter(ParameterEstimatorRunInfo runInfo)
        {
            super(runInfo);
        }

        @Override
        public int getRowCount()
        {
            return 0;
        }

        @Override
        public int getColumnCount()
        {
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex)
        {
            return null;
        }

        @Override
        public String getColumnHeaderToolTip(int visibleColIndex)
        {
            return null;
        }

        @Override
        public String getCellToolTip(int rowIndex, int visibleColIndex)
        {
            return null;
        }
    }
}