package ohd.hseb.hefs.pe.core;

import ohd.hseb.hefs.pe.tools.GenericSummaryTableModel;
import ohd.hseb.hefs.pe.tools.GenericSummaryTableStatusProvider;

@SuppressWarnings("serial")
public class StepTableModel extends GenericSummaryTableModel
{
    protected final Class<? extends ParameterEstimatorStepProcessor> _stepClass;

    public StepTableModel(ParameterEstimatorRunInfo runInfo,
                          Class<? extends ParameterEstimatorStepProcessor> stepClass,
                          GenericSummaryTableStatusProvider... statusProviders)
    {
        super(runInfo, statusProviders);
        _stepClass = stepClass;
    }

    public StepTableModel(ParameterEstimatorRunInfo runInfo,
                          Class<? extends ParameterEstimatorStepProcessor> stepClass,
                          Iterable<GenericSummaryTableStatusProvider> statusProviders)
    {
        super(runInfo, statusProviders);
        _stepClass = stepClass;
    }

    @Override
    protected ParameterEstimatorStepTable instantiateDefaultTable()
    {
        return new ParameterEstimatorStepTable(_stepClass, this);
    }

}
