/*
 * Created on Oct 19, 2011 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.pe.estimation;

import static ohd.hseb.hefs.utils.tools.FileTools.newFile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.tools.FileTools;

/**
 * Generic class to deal with ASCII log files. It is assumed that log files are stored under parameters/logFiles within
 * the base directory, with names of locationId.parameterId.txt. The _workingLogFile can vary from application to
 * application, but should the log file as it is created under working during parameter estimation. Set the working log
 * file by subclassing this, calling super(baseDirectory) within the constructor and then calling setWorkingLogFile.
 * 
 * @author hank.herr
 */
public class EstimationLogFileHandler
{

    private File _baseDirectory;
    private File _logFileDirectory;
    private File _workingLogFile = null;

    public EstimationLogFileHandler(final File baseDirectory)
    {
        setBaseDirectory(baseDirectory);
    }

    public void setBaseDirectory(final File baseDirectory)
    {
        _baseDirectory = baseDirectory;
        _logFileDirectory = newFile(_baseDirectory.getAbsolutePath(), "parameters", "logFiles");
    }

    public File getLogFileDirectory()
    {
        return _logFileDirectory;
    }

    public void setLogFileDirectory(final File logFileDirectory)
    {
        this._logFileDirectory = logFileDirectory;
    }

    public File getWorkingLogFile()
    {
        return _workingLogFile;
    }

    public void setWorkingLogFile(final File workingLogFile)
    {
        this._workingLogFile = workingLogFile;
    }

    public File determineFinalLogFile(final LocationAndDataTypeIdentifier identifier)
    {
        return new File(_logFileDirectory.getAbsolutePath() + File.separator + identifier.getLocationId() + "."
            + identifier.getParameterId() + ".txt");
    }

    public void moveLogFileFromWorking(final LocationAndDataTypeIdentifier identifier) throws Exception
    {
        final File logFile = this.determineFinalLogFile(identifier);
        if(_workingLogFile == null)
        {
            throw new Exception("The working log file has not been specified within " + this.getClass());
        }
        if(!_workingLogFile.exists())
        {
            throw new FileNotFoundException("File " + _workingLogFile.getAbsolutePath() + " not found.");
        }
        if(!_workingLogFile.renameTo(logFile))
        {
            throw new IOException("Move of file " + _workingLogFile.getAbsolutePath() + " to "
                + logFile.getAbsolutePath() + " failed.");
        }
    }

    /**
     * Moves log file into an alternate dir. The directory structure under alternateDir must mimic that under the
     * standard parameters directory; i.e., it must have a subdirectory logFiles to contain the log files.
     * 
     * @param alternateDir The alternate directory, which has the same dir structure as parameters.
     * @param identifier
     * @param swapFiles If true, the parameter files will be swapped with any existing files by the same name. This is
     *            used for recovering backup files.
     * @throws IOException
     */
    public void moveOrSwapLogFileToAlternateDir(final File alternateDir,
                                                final LocationAndDataTypeIdentifier identifier,
                                                final boolean swapFiles) throws IOException
    {
        final File baseFile = determineFinalLogFile(identifier);

        final File oldDir = _logFileDirectory;
        _logFileDirectory = new File(alternateDir.getAbsolutePath() + File.separator + "logFiles");
        final File targetFile = determineFinalLogFile(identifier);
        _logFileDirectory = oldDir;

        FileTools.moveOrSwapFiles(baseFile, targetFile, swapFiles);
    }

    /**
     * Remove the log file for the provided identifier.
     */
    public void removeLogFile(final LocationAndDataTypeIdentifier identifier)
    {
        determineFinalLogFile(identifier).delete();
    }
}
