package ohd.hseb.hefs.pe.estimation;

import java.util.List;

import ohd.hseb.hefs.pe.core.ParameterEstimatorDiagnosticPanel;
import ohd.hseb.hefs.pe.model.FullModelParameters;
import ohd.hseb.hefs.pe.model.ModelParameterType;
import ohd.hseb.hefs.pe.sources.SourceModelParameters;
import ohd.hseb.hefs.utils.jobs.GenericJob;

public interface ParameterDiagnosticPanelGenerator
{
    /**
     * @param job The {@link GenericJob} that is calling this method.
     * @param displayedParameterTypes A list of the parameter types to display.
     * @return A {@link ParameterEstimatorDiagnosticPanel} ready for display.
     * @throws Exception
     */
    public ParameterEstimatorDiagnosticPanel buildDiagnosticPanel(final GenericJob job,
                                                                  final FullModelParameters fullParameters,
                                                                  final SourceModelParameters sourceParameters,
                                                                  final List<ModelParameterType> displayedParameterTypes) throws Exception;

}
