package ohd.hseb.hefs.pe.estimation;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

import ohd.hseb.hefs.pe.tools.LocationAndDataTypeIdentifier;
import ohd.hseb.hefs.utils.gui.tools.SelfListeningButton;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;
import ohd.hseb.hefs.utils.tools.StringTools;

import org.apache.commons.io.FileUtils;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class ViewLogButton extends SelfListeningButton
{
    private final EstimationLogFileHandler _handler;
    private LocationAndDataTypeIdentifier _identifier;

    public ViewLogButton(final EstimationLogFileHandler handler)
    {
        super("viewLog20x20", "View the parameter estimation log for the selected location");
        _handler = handler;
        this.setIdentifier(null);
    }

    public void setIdentifier(final LocationAndDataTypeIdentifier identifier)
    {
        _identifier = identifier;
        if(identifier == null)
        {
            setEnabled(false);
            setToolTipText("Cannot view log: no MEFP location is selected");

        }
        else
        {

            final File file = _handler.determineFinalLogFile(_identifier);
            if(!file.exists())
            {
                setEnabled(false);
                setToolTipText("Cannot view log: log file for " + _identifier.buildStringToDisplayInTree()
                    + " does not exist");
            }
            else
            {
                setEnabled(true);
                setToolTipText("View the parameter estimation log for the selected location");
            }
        }
    }

    /**
     * Lets this button know which identifiers to display the log for. At present, this only works if exactly one
     * identifier is set.
     * 
     * @param identifiers the identifiers to use
     */
    @Subscribe
    public void setIdentifiers(final Collection<LocationAndDataTypeIdentifier> identifiers)
    {
        if(identifiers.size() == 1)
        {
            this.setIdentifier(identifiers.iterator().next());
        }
        else
        {
            this.setIdentifier(null);
        }
    }

    /**
     * Displays the log file.
     */
    @Override
    public void actionPerformed(final ActionEvent evt)
    {
        if(_identifier == null)
        {
            JOptionPane.showMessageDialog(SwingTools.getGlobalDialogParent(this),
                                          "Please select exactly one location for which to view the log file.",
                                          "Error Viewing Log File!",
                                          JOptionPane.ERROR_MESSAGE);
        }
        else
        {
            final File file = _handler.determineFinalLogFile(_identifier);
            if(file.length() > 60 * FileUtils.ONE_MB)
            {
                JOptionPane.showMessageDialog(SwingTools.getGlobalDialogParent(this),
                                              StringTools.wordWrap("Log file " + file.getAbsolutePath()
                                                  + " is too large to view.", 100),
                                              "Error Viewing Log File!",
                                              JOptionPane.ERROR_MESSAGE);
                return;
            }

            try
            {
                if(file.exists())
                {
                    final JEditorPane editorPane = new JEditorPane(file.toURI().toURL());
                    final JFrame frame = new JFrame();
                    frame.setTitle("Estimation Log File for " + _identifier.buildStringToDisplayInTree());
                    frame.add(new JScrollPane(editorPane));
                    frame.setSize(new Dimension(500, 500));
                    frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
                    frame.setVisible(true);
                }
                else
                {
                    JOptionPane.showMessageDialog(SwingTools.getGlobalDialogParent(this),
                                                  "Log file " + file.getAbsolutePath() + " does not exist.",
                                                  "Error Viewing Log File!",
                                                  JOptionPane.ERROR_MESSAGE);
                }
            }
            catch(final Exception e)
            {
                e.printStackTrace();
            }
        }
    }
}
