package ohd.hseb.hefs.pe.estimation.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBox;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.xml.XMLVariable;
import ohd.hseb.hefs.utils.xml.vars.XMLBoolean;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class BooleanEstimationOption extends EditableLeafControlOption<Boolean>
{
    protected BooleanEstimationOption(final XMLVariable<Boolean> variable, final String label)
    {
        super(variable, label);
    }

    public BooleanEstimationOption(final String xmlTag, final String label)
    {
        this(xmlTag, label, false);
    }

    public BooleanEstimationOption(final String xmlTag, final String label, final Boolean value)
    {
        this(new XMLBoolean(xmlTag, value), label);
    }

    // Takes care of label on its own, so override.
    @Override
    public JCheckBox makeEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        final JCheckBox editor = makeEditorEditor();
        register(editor);
        return editor;
    }

    @Override
    public Editor makeEditorEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        return new Editor();
    }

    protected class Editor extends JCheckBox implements VariableSetNotice.Subscriber
    {
        private Editor()
        {
            super(_label, false);

            update();

            addActionListener(new ActionListener()
            {
                @Override
                public void actionPerformed(final ActionEvent e)
                {
                    set(isSelected(), this);
                }
            });

            BooleanEstimationOption.this.register(this);
        }

        private void update()
        {
            final Boolean value = get();
            if(value != null)
            {
                setSelected(value);
            }
        }

        @Override
        @Subscribe
        public void reactToVariableSet(final VariableSetNotice evt)
        {
            update();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final BooleanEstimationOption copy = new BooleanEstimationOption(getXMLTagName(), this._label);
        copy.setDefaultValue(getDefaultValue());
        copy.set(this.get());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        setXMLTagName(base.getXMLTagName());
        set(((BooleanEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Boolean>)base).getDefaultValue());
    }
}
