package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JComponent;

import ohd.hseb.hefs.utils.notify.Notifier;
import ohd.hseb.hefs.utils.xml.XMLReadable;
import ohd.hseb.hefs.utils.xml.XMLWritable;

import com.google.common.base.Supplier;

/**
 * An implementor is assumed to store a block of control parameters, typically associated with a data source, or
 * possibly another step to be performed.
 * 
 * @author hank.herr
 */
public interface ControlOption<T> extends XMLReadable, XMLWritable, Supplier<T>, Notifier, Cloneable
{
    /**
     * @throws IllegalStateException if this is not in a valid state
     */
    void assertValid() throws IllegalStateException;

    /**
     * @return a swing component which allows the user to edit this parameter
     */
    JComponent makeEditor();

    /**
     * Reset this parameter to its initial value
     */
    void setToDefault();

    /**
     * Set the default value for this control option.
     */
    void setDefaultValue(T value);

    /**
     * A clone method is required by any implementer!
     * 
     * @return Cloned object.
     * @throws CloneNotSupportedException
     */
    public Object clone() throws CloneNotSupportedException;

    /**
     * Copies this parameter so that it matches the given parameter object. Be sure to account for all parts of the
     * {@link ControlOption}, including possible a default value if {@link GenericLeafControlOption} is used.
     * 
     * @param base
     */
    public void copyFrom(ControlOption base);

    /**
     * @return The XML tag for a variable.
     */
    public String getXMLTagName();
}
