package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

import ohd.hseb.hefs.pe.core.ParameterEstimatorRunInfo;
import ohd.hseb.hefs.pe.estimation.EstimationPEStepOptionsPanel;

/**
 * And {@link UndoableEdit} for use with an {@link UndoManager}. This class stores working options, that should be the
 * same object as that which is within a {@link ParameterEstimatorRunInfo} underlying the current PE. It also stores old
 * options, for use when undoing, and the new options which contain the change associated with this undo edit. It also s
 * stores a scroll position, but is unable to apply that itself; see {@link EstimationPEStepOptionsPanel} for how
 * {@link #getScrollPosition()} is called/used.
 * 
 * @author hankherr
 */
public class ControlOptionUndoableEdit implements UndoableEdit
{
    private final EstimationControlOptions _workingOptions;
    private final EstimationControlOptions _oldOptions;
    private final EstimationControlOptions _newOptions;
    private final int _scrollPosition;

    /**
     * @param workingOptions The options that can be modified to perform the undo/redo actions of this edit event.
     * @param oldOptions The previous settings for the options; undo will recover these.
     * @param newOptions The new/current settings for the options; redo will recover these.
     * @param scrollPositionOfOptionsScrollPane The scroll position index.
     */
    public ControlOptionUndoableEdit(final EstimationControlOptions workingOptions,
                                     final EstimationControlOptions oldOptions,
                                     final EstimationControlOptions newOptions,
                                     final int scrollPositionOfOptionsScrollPane)
    {
        _workingOptions = workingOptions;
        _oldOptions = oldOptions.clone();
        _newOptions = newOptions.clone();
        _scrollPosition = scrollPositionOfOptionsScrollPane;
    }

    /**
     * @return If {@link #_oldOptions} does not equal {@link #_newOptions}; i.e., the edit is actually a change and not
     *         a by product of something else.
     */
    public boolean doesEditReflectAChange()
    {
        return !_oldOptions.equals(_newOptions);
    }

    public int getScrollPosition()
    {
        return _scrollPosition;
    }

    public EstimationControlOptions getOldOptions()
    {
        return _oldOptions;
    }

    public EstimationControlOptions getNewOptions()
    {
        return _newOptions;
    }

    @Override
    public void undo() throws CannotUndoException
    {
        _workingOptions.copyFrom(_oldOptions);
    }

    @Override
    public boolean canUndo()
    {
        return true;
    }

    @Override
    public void redo() throws CannotRedoException
    {
        _workingOptions.copyFrom(_newOptions);
    }

    @Override
    public boolean canRedo()
    {
        return true;
    }

    @Override
    public void die()
    {
    }

    @Override
    public boolean addEdit(final UndoableEdit anEdit)
    {
        return false;
    }

    @Override
    public boolean replaceEdit(final UndoableEdit anEdit)
    {
        return false;
    }

    @Override
    public boolean isSignificant()
    {
        return true;
    }

    @Override
    public String getPresentationName()
    {
        return null;
    }

    @Override
    public String getUndoPresentationName()
    {
        return null;
    }

    @Override
    public String getRedoPresentationName()
    {
        return null;
    }

}
