package ohd.hseb.hefs.pe.estimation.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;

import javax.swing.JComboBox;
import javax.swing.JComponent;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.dist.DistributionType;

import com.google.common.eventbus.Subscribe;

/**
 * A control option that wraps a {@link DistributionType}. The constructor takes an {@link EnumSet} of
 * {@link DistributionType} values, which can be manually built or acquired from constants within
 * {@link DistributionType}, such as {@link DistributionType#MOMENTS_FITTING_POSTIVE_BOUNDED_DISTRIBUTIONS}.
 * 
 * @author hankherr
 */
@SuppressWarnings("serial")
public class DistributionEstimationOption extends EditableLeafControlOption<DistributionType>
{
    private final EnumSet<DistributionType> _usableDistributions;

    public DistributionEstimationOption(final String xmlTag,
                                        final EnumSet<DistributionType> usableDistributions,
                                        final String label)
    {
        super(new DistributionType.Variable(xmlTag, DistributionType.WEIBULL), label);
        _usableDistributions = usableDistributions;
    }

    @Override
    public JComponent makeEditorEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        return new Editor();
    }

    /**
     * Editor component for this control option.
     * 
     * @author hankherr
     */
    private class Editor extends JComboBox implements VariableSetNotice.Subscriber
    {

        /**
         * I am unable to get around a problem where calling update triggers an action which calls update again and so
         * on. Specifically, I've tried to remove the action listener when updating, but that does not work, perhaps due
         * to a threading or bus issue of some kind. Hence, I created this flag.
         */
        boolean _isUpdating = false;

        private Editor()
        {
            super(_usableDistributions.toArray());

            update();

            addActionListener(new ActionListener()
            {
                @Override
                public void actionPerformed(final ActionEvent e)
                {
                    if(!_isUpdating)
                    {
                        set((DistributionType)getSelectedItem(), this);
                    }
                }
            });

            register(this);
        }

        /**
         * An update to make the editor match the option should not retrigger an action event. Hence {@link #_listener}
         * is removed and added when {@link #setSelectedItem(Object)} is called in here.
         */
        private void update()
        {
            _isUpdating = true;
            final DistributionType dist = get();
            if(dist != null)
            {
                setSelectedItem(dist);
            }
            _isUpdating = false;
        }

        @Override
        @Subscribe
        public void reactToVariableSet(final VariableSetNotice evt)
        {
            update();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final DistributionEstimationOption copy = new DistributionEstimationOption(getXMLTagName(),
                                                                                   _usableDistributions,
                                                                                   _label);
        copy.setDefaultValue(getDefaultValue());
        copy.set(get());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        final DistributionEstimationOption toCopy = (DistributionEstimationOption)base;
        setXMLTagName(base.getXMLTagName());
        _label = toCopy._label;
        set(((DistributionEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<DistributionType>)base).getDefaultValue());
    }
}
