package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.gui.components.GenericSpinner;
import ohd.hseb.hefs.utils.tools.GeneralTools;
import ohd.hseb.hefs.utils.xml.vars.XMLDouble;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class DoubleEstimationOption extends EditableLeafControlOption<Double>
{
    private double _step;
    private Double _min;
    private Double _max;

    public DoubleEstimationOption(final String xmlTag, final String label)
    {
        this(xmlTag, label, null);
    }

    public DoubleEstimationOption(final String xmlTag,
                                  final String label,
                                  final Double value,
                                  final double step,
                                  final Double min,
                                  final Double max)
    {
        super(new XMLDouble(xmlTag, value), label);
        _step = step;
        _min = min;
        _max = max;
    }

    public DoubleEstimationOption(final String xmlTag, final String label, final Double value)
    {
        this(xmlTag, label, value, 1, null, null);
    }

    @Override
    public JComponent makeEditorEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        return new Editor();
    }

    private class Editor extends GenericSpinner implements VariableSetNotice.Subscriber
    {
        private Editor()
        {
            super(new SpinnerNumberModel(GeneralTools.firstNonNull(_min, _max, 0f), _min, _max, _step));
            disableDefaultMouseWheelListener();

            final NumberEditor edit = new JSpinner.NumberEditor(this);
            edit.getFormat().setGroupingUsed(false);
            setEditor(edit);

            update();

            addChangeListener(new ChangeListener()
            {
                @Override
                public void stateChanged(final ChangeEvent e)
                {
                    set(((Number)getValue()).doubleValue(), this);
                }
            });

            register(this);
        }

        private void update()
        {
            final Double value = get();
            if(value != null)
            {
                setValue(value);
            }
        }

        @Override
        @Subscribe
        public void reactToVariableSet(final VariableSetNotice evt)
        {
            update();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final DoubleEstimationOption copy = new DoubleEstimationOption(getXMLTagName(),
                                                                       _label,
                                                                       get(),
                                                                       _step,
                                                                       _min,
                                                                       _max);
        copy.setDefaultValue(getDefaultValue());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        final DoubleEstimationOption toCopy = (DoubleEstimationOption)base;
        setXMLTagName(base.getXMLTagName());
        _step = toCopy._step;
        _min = toCopy._min;
        _max = toCopy._max;
        _label = toCopy._label;
        set(((DoubleEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Double>)base).getDefaultValue());
    }
}
