package ohd.hseb.hefs.pe.estimation.options;

import java.awt.event.ActionEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.gui.tools.SelfListeningButton;
import ohd.hseb.hefs.utils.xml.XMLVariable;

/**
 * Splits a parameter's editor into a label and an actual editor.
 * 
 * @author alexander.garbarino
 * @param <T>
 */
public abstract class EditableLeafControlOption<T> extends GenericLeafControlOption<T>
{
    protected String _label;

    protected EditableLeafControlOption(final XMLVariable<T> valueManager, final String label)
    {
        super(valueManager);
        _label = label;
    }

    public String getLabel()
    {
        return _label;
    }

    /**
     * Creates a panel containing {@link #makeEditorLabel()} and {@link #makeEditorEditor()}.
     */
    @SuppressWarnings("serial")
    @Override
    public JComponent makeEditor()
    {
        final JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        panel.add(makeEditorLabel());
        panel.add(makeEditorEditor());
        final JButton defaultButton = new SelfListeningButton("Default")
        {
            @Override
            public void actionPerformed(final ActionEvent e)
            {
                setToDefault();
            }
        };
        panel.add(defaultButton);

        return panel;
    }

    /**
     * Creates the label describing the editor.
     */
    public JLabel makeEditorLabel()
    {
        return new JLabel(_label);
    }

    /**
     * Creates the actual component which will do the editing. <br/>
     * Should implement {@link VariableSetNotice.Subscriber} and register itself if it wants to react to the variable
     * being read.
     */
    public abstract JComponent makeEditorEditor();
}
