package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import ohd.hseb.hefs.utils.VariableSetNotice;
import ohd.hseb.hefs.utils.gui.components.GenericSpinner;
import ohd.hseb.hefs.utils.gui.tools.ReachBoundsSpinnerNumberModel;
import ohd.hseb.hefs.utils.tools.GeneralTools;
import ohd.hseb.hefs.utils.xml.vars.XMLFloat;

import com.google.common.eventbus.Subscribe;

@SuppressWarnings("serial")
public class FloatEstimationOption extends EditableLeafControlOption<Float>
{
    private float _step;
    private Float _min;
    private Float _max;

    public FloatEstimationOption(final String xmlTag, final String label, final float step)
    {
        super(new XMLFloat(xmlTag), label);
        _step = step;
        _min = null;
        _max = null;
    }

    public FloatEstimationOption(final String xmlTag, final String label, final Float value, final float step)
    {
        this(xmlTag, label, value, step, null, null);
    }

    public FloatEstimationOption(final String xmlTag,
                                 final String label,
                                 final Float value,
                                 final float step,
                                 final Float min,
                                 final Float max)
    {
        super(new XMLFloat(xmlTag, value), label);
        _step = step;
        _min = min;
        _max = max;
    }

    @Override
    public Editor makeEditorEditor()
    {
        if(getLabel() == null)
        {
            return null;
        }
        return new Editor();
    }

    private class Editor extends GenericSpinner implements VariableSetNotice.Subscriber
    {
        private Editor()
        {
            super(new ReachBoundsSpinnerNumberModel(GeneralTools.firstNonNull(_min, _max, 0f), _min, _max, _step));
            disableDefaultMouseWheelListener();

            final NumberEditor edit = new JSpinner.NumberEditor(this);
            edit.getFormat().setGroupingUsed(false);
            setEditor(edit);

            update();

            addChangeListener(new ChangeListener()
            {
                @Override
                public void stateChanged(final ChangeEvent e)
                {
                    set(((Number)getValue()).floatValue(), this);
                }
            });

            register(this);
        }

        private void update()
        {
            final Float value = get();
            if(value != null)
            {
                setValue(value);
            }
        }

        @Override
        @Subscribe
        public void reactToVariableSet(final VariableSetNotice evt)
        {
            update();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException
    {
        final FloatEstimationOption copy = new FloatEstimationOption(getXMLTagName(), _label, get(), _step, _min, _max);
        copy.setDefaultValue(getDefaultValue());
        return copy;
    }

    @Override
    public void copyFrom(final ControlOption base)
    {
        final FloatEstimationOption toCopy = (FloatEstimationOption)base;
        setXMLTagName(base.getXMLTagName());
        _step = toCopy._step;
        _min = toCopy._min;
        _max = toCopy._max;
        _label = toCopy._label;
        set(((FloatEstimationOption)base).get());
        setDefaultValue(((GenericLeafControlOption<Float>)base).getDefaultValue());
    }
}
