package ohd.hseb.hefs.pe.estimation.options;

import javax.swing.JComponent;

import ohd.hseb.hefs.utils.notify.NoticeForwarder;
import ohd.hseb.hefs.utils.xml.XMLReader;
import ohd.hseb.hefs.utils.xml.XMLVariable;
import ohd.hseb.hefs.utils.xml.XMLWriter;

import com.google.common.base.Objects;

/**
 * Abstract class for a single {@link ControlOption}. This wraps a {@link XMLVariable}, making it a
 * {@link ControlOption}.
 * 
 * @author alexander.garbarino
 * @param <T>
 */
public abstract class GenericLeafControlOption<T> extends NoticeForwarder implements ControlOption<T>
{

    protected XMLVariable<T> _valueManager;

    private T _default;

    protected GenericLeafControlOption(final XMLVariable<T> valueManager)
    {
        _valueManager = valueManager;

        _valueManager.register(this);

        _default = _valueManager.get();
    }

    public boolean isDefaultValue()
    {
        return _default.equals(get());
    }

    @Override
    public T get()
    {
        return _valueManager.get();
    }

    public void set(final T value)
    {
        _valueManager.set(value, this);
    }

    public void set(final T value, final Object source)
    {
        _valueManager.set(value, source);
    }

    /**
     * Creates the value portion of the fortran info. Defaults to {@link #toString()}.
     * 
     * @param value the value to write
     * @return the value as it will appear in the fortran file
     */
    protected String writeFortranValue(final T value)
    {
        return value.toString();
    }

    public void setXMLTagName(final String xmlTag)
    {
        _valueManager.setXMLTagName(xmlTag);
    }

    protected T getDefaultValue()
    {
        return _default;
    }

    @Override
    public String getXMLTagName()
    {
        return _valueManager.getXMLTagName();
    }

    /**
     * Defaults to no editor. Override this.
     */
    @Override
    public JComponent makeEditor()
    {
        return null;
    }

    @Override
    public XMLReader getReader()
    {
        return _valueManager.getReader();
    }

    @Override
    public XMLWriter getWriter()
    {
        return _valueManager.getWriter();
    }

    @Override
    public void assertValid() throws IllegalStateException
    {
        // Assume valid.
    }

    @Override
    public void setToDefault()
    {
        _valueManager.set(_default);
    }

    @Override
    public void setDefaultValue(final T value)
    {
        _default = value;
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(_valueManager);
    }

    @Override
    public boolean equals(final Object other)
    {
        if(this == other)
        {
            return true;
        }

        if(!(other instanceof GenericLeafControlOption<?>))
        {
            return false;
        }
        final GenericLeafControlOption<?> that = (GenericLeafControlOption<?>)other;

        return Objects.equal(this._valueManager, that._valueManager);
    }

    /**
     * When overriding, be sure to account for the {@link #_default}, which is set via {@link #setDefaultValue(Object)}.
     */
    @Override
    public abstract Object clone() throws CloneNotSupportedException;

}
